
# SOBA テクニカルノート

## SOBA が持つ機能

 * 指定ディレクトリ，あるいは JAR ファイルからクラス情報を読み込む機能．読み込まれたデータは JavaProgram オブジェクトとして表現されます．
 * 読み込んだクラス群が持つメソッドに対して，バイトコードの命令をノードとした制御フローグラフ，制御依存関係，データ依存関係を取得することができます． 
 * Class Hierarchy Analysis と Variable Type Analysis を使った動的束縛の解決


## 解析時の注意点

### バイトコードだけからでは，ソースコード位置を特定できないメソッドが存在する

各メソッドのソースコード上での定義位置は `LineNumberTable` から知ることができるが，
命令が１つもなく，戻り値が void 型であるようなメソッドは，命令がないために行番号も持たない．
そのため，バイトコードだけからでは，メソッドの宣言位置を特定できない．



### メソッドの実装が１つも存在しなければ動的束縛の解決結果は空になる

CHA や VTA を使って「動的束縛の解決後」の呼び出し関係を取り出す場合は，
メソッドの定義が存在するように，うまくクラスパスを設定しなくてはならない．
対応するメソッドの定義が検索範囲に1つも含まれていない場合，
動的束縛の解決結果（実際に呼ばれうるメソッドの集合）は空集合となる．
呼び出し関係をグラフ化する場合などには，呼び出しが「なかったことになる」ため，注意が必要である．


### Generic Types はまじめに扱っていない

メソッドの引数に関する Generic Types は，何も考えず型パラメータの中身を文字列展開している．
クラスの型パラメータ自体がそのままメソッドの引数に出ている可能性があるので，「すべて実際の型」とは考えてはいけない．

ASM での Generics の使い方は，
[IBM dW: クラスワーキング・ツールキット: ASMとジェネリックス](http://www.ibm.com/developerworks/jp/java/library/j-cwt02076/)と，
[ASM API JavaDoc: SignatureVisitor](http://www.docjar.com/docs/api/org/objectweb/asm/signature/SignatureVisitor.html)クラスの内容を参照するとよい．


### 異なるソースコードが同一バイトコードになる例が存在する

`if (X && Y) {` と `if (X) { if (Y) {` という２つの記述方法は，前者だと２つの条件分岐命令の間に LABEL ノードが入らず，後者は入るために区別可能．

`if ((X || !Y) && (!X || Y)) {` のように条件分岐が複雑になる（IF式中に合流点が生じる）と，
OR で判定された結果が合流するための LABEL ノードが条件分岐命令間に生成されてしまい，IF文2つを入れ子で記述した場合とまったく同一のバイトコードになる．


### INVOKEDYNAMIC の解析はできない

ASM の機能としてはサポートされているが，SOBA でこの情報を活用できるようにはしていない．

