package org.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.jdbc.Scheme;

/**
 * JDBC Driver class
 * @author calico
 */
public class Driver implements java.sql.Driver {
    static {
        try {
            System.loadLibrary("sqlite3jni");
            DriverManager.registerDriver(new org.sqlite.Driver());
        } catch (SQLException ex) {
            Logger.getLogger(Driver.class.getName()).throwing(Driver.class.getName(), "<clinit>", ex);
            throw new Error(ex.fillInStackTrace());
        }
    }

    public static String getDriverName() {
        return "SQLite JDBC Driver";
    }
    
    public static String getDriverVersion() {
        return getDriverMajorVersion()
                + "." + getDriverMinorVersion()
                + "." + getDriverReleaseVersion();
    }
    
    // TODO バージョン情報は外部ファイル化すべき？
    public static int getDriverMajorVersion() {
        return 0;
    }
    
    public static int getDriverMinorVersion() {
        return 0;
    }
    
    public static int getDriverReleaseVersion() {
        return 1;
    }
    
    // START implements
    public boolean acceptsURL(String url) {
        for (Scheme scheme : Scheme.values()) {
            if (scheme.matches(url)) {
                return true;
            }
        }
        return false;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!acceptsURL(url)) {
            return null;
        }

        for (Scheme scheme : Scheme.values()) {
            final String filename = scheme.getFilename(url);
            if (filename != null) {
                final String schm = scheme.toString();
                return new org.sqlite.jdbc.JdbcConnection(schm, filename);
            }
        }
    
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public int getMajorVersion() {
        return getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        // TODO do implements!
        return new DriverPropertyInfo[] {
                    new DriverPropertyInfo("encoding", "UTF-8"),
                    new DriverPropertyInfo("lastUpdateCount", "true"),
                    new DriverPropertyInfo("busyTimeout", "0"),
                    new DriverPropertyInfo("cacheSize", "2000"),
                    // @see sqliteLimit.h - SQLITE_DEFAULT_CACHE_SIZE
                    new DriverPropertyInfo("defaultCacheSize", "2000"),
                    // @see sqliteLimit.h - SQLITE_DEFAULT_PAGE_SIZE
                    new DriverPropertyInfo("pageSize", "1024"),
                    // @see sqliteLimit.h - SQLITE_MAX_PAGE_COUNT
                    new DriverPropertyInfo("maxPageCount", "1073741823"),
                };
    }

    public boolean jdbcCompliant() {
        return false;
    }
    // END implements
    
}
