/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.io;

import java.io.IOException;
import java.io.InputStream;
import org.sqlite.jdbc.JdbcBlob;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_void;

/**
 *
 * @author calico
 */
public class BlobInputStream extends InputStream  {
    private final JdbcBlob owner;
    private final SWIGTYPE_p_void blob;
    private final long last;
    private long pos;
    private long mark;
    private boolean isClosed = false;
    
    public BlobInputStream(JdbcBlob owner, SWIGTYPE_p_void blob, long len) {
        this.owner = owner;
        this.blob = blob;
        this.last = len - 1;
    }

    @Override
    public int available() throws IOException {
        validateStreamOpen();
        
        return  (pos > last ? 0 : (int) (last - pos));
    }

    @Override
    public void close() throws IOException {
        isClosed = true;
    }

    /**
     * 
     * Note: The readlimit for this class has no meaning.
     * 
     * @param readlimit
     */
    @Override
    public synchronized void mark(int readlimit) {
        mark = pos;
    }

    /**
     * mark() supported.
     * @return true
     */
    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        final byte[] b = new byte[1];
        return (read(b, 0, 1) != -1 ? b[0] : -1);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        validateStreamOpen();

        if (pos > last) {
            return -1;
        }
        
        if (pos + len > last) {
            len -= ((pos + len) - (last + 1));
        }
        if (len == 0) {
            return 0;
        }
        
        SQLite3.read_blob(blob, pos, b, off, len);
        pos += len;
        return (pos > last ? -1 : len);
    }

    @Override
    public synchronized void reset() throws IOException {
        validateStreamOpen();
        
        pos = mark;
    }

    @Override
    public long skip(long n) throws IOException {
        validateStreamOpen();

        if (pos > last) {
            return 0;
        }
        
        pos += n;
        return (pos > last ? n - (pos - last) : n);
    }
    
    private void validateStreamOpen() throws IOException {
        if (isClosed || owner.isClosed()) {
            throw new IOException("Stream is already closed.");
        }
    }

}
