/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.util.Properties;

/**
 * JDBC URL Schemes.
 * @author calico
 */
public enum Scheme {
    JDBC_SQLITE_FILE("jdbc:sqlite:file:"),
    JDBC_SQLITE_MEMORY("jdbc:sqlite:mem:") {
        @Override
        public String getFilename(String url) {
            if (matches(url)) {
                return ":memory:";
            }
            return null;
        }
    },
    JDBC_SQLITE("jdbc:sqlite:");
    /* URL Schemes for SQLite.JDBCDriver  */
//    CHRISTIAN_JDBC_SQLITE("jdbc:sqlite:/"),
//    CHRISTIAN_SQLITE("sqlite:/");

    private final String scheme;

    private Scheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean matches(String url) {
        return url.startsWith(scheme);
    }

    public String getFilename(String url) {
        if (matches(url)) {
            return url.substring(scheme.length());
        }
        return null;
    }
    
    public Properties getOptions(String url) {
        // TODO do implements!
        // for example:
        // open exist file and read only mode:
        //      jdbc:sqlite:file:\My Documents\sqlite\database;OPEN_MODE=READONLY
        // open exist file and read/write mode:
        //      jdbc:sqlite:file:\My Documents\sqlite\database;OPEN_MODE=READWRITE
        // open exist file or create file and read/write mode (DEFAULT):
        //      jdbc:sqlite:file:\My Documents\sqlite\database;OPEN_MODE=CREATE
        return null;
    }

    @Override
    public String toString() {
        return scheme;
    }
}
