/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Context;

/**
 * User-Defined function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 * @see org.sqlite.jdbc.JdbcConnection#registerFunction(Function)
 * @see org.sqlite.jdbc.JdbcConnection#unregisterFunction(Function)
 */
public abstract class Function {
    protected final String name;
    protected final int argc;
    
    /** pointer of myself  */
    private volatile long _this;

    protected Function(String name) {
        this(name, -1);
    }
    
    protected Function(String name, int argc) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.argc = argc;
    }
    
    public String getName() {
        return name;
    }
    
    public int getArgumentCount() {
        return argc;
    }
    
    public boolean isRegistered() {
        return (_this != 0);
    }

    /**
     * Called from the sqlite3_step() function.
     * @param context
     * @param argc
     * @param value
     */
    protected final void xFunc(long context, int argc, long value) {
        // TODO Mysaifu JVMのBug#11980が解決したらアクセス修飾子をprivateに戻すこと！
        // @see http://sourceforge.jp/tracker/index.php?func=detail&aid=11980&group_id=1890&atid=7027
        Context ctx = null;
        try {
            ctx = new Context(context, argc, value);
            xFunc(ctx);
            
        } catch (Throwable th) {
            if (ctx != null) {
                final String msg = th.toString();
                ctx.resultError((msg != null ? msg : "unknown error."));
                
            } else {
                Logger.getLogger(Function.class.getName()).fine("Exception occurred: " + th.toString());
            }
        }
    }
    
    protected abstract void xFunc(Context ctx) throws SQLException;
}
