/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class ScalarFunctionTest {

    public ScalarFunctionTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test
    public void createFunction() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        try {
            final Function myFunc
                    = new ScalarFunction("myFunc") {
                            @Override
                            public void xFunc(Context ctx) throws SQLException {
                                System.out.println("called xFunc()!");
                                String val = ctx.getString(1);
                                ctx.result(val);
                            }
                        };
            assertFalse(myFunc.isRegistered());
            db.createFunction(myFunc);
            assertTrue(myFunc.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT myFunc('TEST') LIMIT 1");
            assertTrue(rs.next());
            assertEquals("TEST", rs.getString(1));
            rs.close();
            
            db.dropFunction(myFunc);
            assertFalse(myFunc.isRegistered());
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }
    }

    @Test(expected = java.sql.SQLException.class)
    public void dropFunction() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        try {
            final Function myFunc
                    = new ScalarFunction("myFunc") {
                            @Override
                            public void xFunc(Context ctx) {
                                System.out.println("called xFunc()!");
                            }
                        };
            assertFalse(myFunc.isRegistered());
            db.createFunction(myFunc);
            assertTrue(myFunc.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT myFunc('TEST') LIMIT 1");
            assertTrue(rs.next());
            assertNull(rs.getString(1));
            rs.close();
            
            db.dropFunction(myFunc);
            assertFalse(myFunc.isRegistered());

            rs = stmt.executeQuery("SELECT myFunc('TEST') LIMIT 1");
            rs.close();
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }
    }
}