import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Types;
import org.sqlite.jdbc.JdbcPreparedStatement;

public class HelloSQLite {

    public static void main(String[] args) throws Exception {
        // register 'org.sqlite.Driver' class
        Class.forName("org.sqlite.Driver");

        // open connection
        String url = null;
        if (args.length == 0) {
            System.out.println("open database in-memory mode.");
            url = "jdbc:sqlite:mem:";
        } else {
            System.out.println("open database from '" + args[0] + "'.");
            url = "jdbc:sqlite:file:" + args[0];
        }
        final Connection conn = DriverManager.getConnection(url);

        try {
            // create table if not exists
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(
                    "CREATE TABLE IF NOT EXISTS sample("
                        + "  id INTEGER PRIMARY KEY"
                        + ", tVal TEXT"
                        + ", bVal BLOB"
                        + ", rVal REAL"
                    + ")"
                );
            stmt.close();

            // insert new record by using a named parameter
            conn.setAutoCommit(false);
            JdbcPreparedStatement pstmt
                = (JdbcPreparedStatement) conn.prepareStatement(
                        "INSERT INTO sample(tVal, bVal, rVal) "
                        + "VALUES(@text, @blob, @real)"
                    );
            for (int i = 0; i < 5; ++i) {
                String text = Character.toString((char) ('1' + i));
                byte[] blob = ("Hello, SQLite3!" + text).getBytes();
                pstmt.setString("@text", text);
                pstmt.setBytes("@blob", blob);
                pstmt.setDouble("@real", Math.sqrt(i));
                pstmt.executeUpdate();
            }
            pstmt.close();
            conn.commit();

            // select all
            System.out.println("** select all records **");
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM sample");
            ResultSetMetaData rsMeta = rs.getMetaData();
            final int cntCol = rsMeta.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= cntCol; ++i) {
                    String val = null;
                    if (rsMeta.getColumnType(i) != Types.BLOB) {
                        val = rs.getString(i);
                    } else {
                        // convert UNICODE to java.lang.String
                        val = new String(rs.getBytes(i));
                    }
                    System.out.print(val + "|");
                }
                System.out.println();
            }
            rs.close();

            stmt.close();

        } finally {
            // close connection
            conn.close();
        }
    }
}
