/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.34
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "sqlite3.h"

/* declare function instead of #include "sqliteInt.h" for sqlite3_get_errmsg(int) */
const char *sqlite3ErrStr(int);

#ifdef __cplusplus
extern "C" {
#endif

/* Field ID of org.sqlite.callback.Callback._this member field */
static jfieldID fid_callback_this = 0;

/* Field ID of org.sqlite.callback.NamedCallback.name member field */
static jfieldID fid_namedcallback_name = 0;

/* org.sqlite.udf.Function class */
static jclass clsFunction = 0;

/* Field ID of org.sqlite.udf.Function member fields  */
static jfieldID fid_function_argc = 0;

/* org.sqlite.udf.AggregateFunction class */
static jclass clsAggregateFunction = 0;

/* org.sqlite.text.Collator class */
static jclass clsCollator = 0;

/* Field ID of org.sqlite.text.Collator.enc member field */
static jfieldID fid_collator_enc = 0;

/* org.sqlite.auth.Authorizer class */
static jclass clsAuthorizer = 0;

/* org.sqlite.event.BusyHandler class */
static jclass clsBusyHandler = 0;

/* org.sqlite.event.CollationNeededHandler class */
static jclass clsCollationNeededHandler = 0;

/* org.sqlite.event.ProgressHandler class */
static jclass clsProgressHandler = 0;

/* org.sqlite.event.CommitHook class */
static jclass clsCommitHook = 0;

/* org.sqlite.event.RollbackHook class */
static jclass clsRollbackHook = 0;

/* org.sqlite.event.UpdateHook class */
static jclass clsUpdateHook = 0;

/* org.sqlite.profiler.Profiler class */
static jclass clsProfiler = 0;

/* org.sqlite.profiler.Tracer class */
static jclass clsTracer = 0;

/* org.sqlite.callback.ExecCallback class */
static jclass clsExecCallback = 0;

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *vm, void *reserved) {
    JNIEnv *jenv = NULL;
    // require JNI ver 1.2 or later
    return ((*vm)->GetEnv(vm, (void **)&jenv, JNI_VERSION_1_2) == JNI_OK ? JNI_VERSION_1_2 : JNI_ERR);
}

/* delete references */
JNIEXPORT void JNICALL JNI_OnUnload(JavaVM *vm, void *reserved) {
    JNIEnv *jenv = NULL;
    if ((*vm)->AttachCurrentThread(vm, (void **)&jenv, 0) == JNI_OK) {
        jclass classes[]
                = {
                        clsFunction, clsAggregateFunction,
                        clsCollator,
                        clsAuthorizer,
                        clsBusyHandler, clsCollationNeededHandler, clsProgressHandler,
                        clsCommitHook, clsRollbackHook, clsUpdateHook,
                        clsProfiler, clsTracer,
                        clsExecCallback,
                  };
        int i = 0;
        int const last = sizeof(classes) / sizeof(classes[0]);
        for (; i < last; ++i) {
            if (classes[i]) {
                (*jenv)->DeleteGlobalRef(jenv, classes[i]);
                classes[i] = 0;
            }
        }
    }
}

/* convert pointer to jlong */
static jlong _jlong(void *p) {
    jvalue val;
    val.l = p;
    return val.j;
}

/* convert jlong to pointer */
static void * _voidp(jlong j) {
    jvalue val;
    val.j = j;
    return (void *)val.l;
}

/* throw new Exception */
static void JavaThrowException(JNIEnv *jenv, const char *clazz, const char *message) {
    if (jenv) {
        jclass ex;
        char *cls = (char *)clazz;
        char *msg = (char *)message;
        (*jenv)->ExceptionClear(jenv);
        ex = (*jenv)->FindClass(jenv, cls);
        if (ex) {
            (*jenv)->ThrowNew(jenv, ex, msg);
            (*jenv)->DeleteLocalRef(jenv, ex);
        }
    }
}

/* sqlite3_column_blob by byte[] */
JNIEXPORT jbyteArray JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong stmt, jint col) {
    sqlite3_stmt *pStmt = (sqlite3_stmt *)_voidp(stmt);
    jsize len;
    jbyteArray result;
    jbyte *pSrc;
    const void *blob = sqlite3_column_blob(pStmt, col);

    if (!blob) {
        return NULL;
    }

    len = sqlite3_column_bytes(pStmt, col);
    result = (*jenv)->NewByteArray(jenv, len);
    if (!result) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }

    pSrc = (*jenv)->GetPrimitiveArrayCritical(jenv, result, 0);
    if (!pSrc) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }
    memcpy(pSrc, blob, len);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, result, pSrc, 0);

    return result;
}

/* sqlite3_value_blob by byte[] */
JNIEXPORT jbyteArray JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong value) {
    sqlite3_value *pVal = (sqlite3_value *)_voidp(value);
    jsize len;
    jbyteArray result;
    jbyte *pSrc;
    const void *blob = sqlite3_value_blob(pVal);

    if (!blob) {
        return NULL;
    }

    len = sqlite3_value_bytes(pVal);
    result = (*jenv)->NewByteArray(jenv, len);
    if (!result) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }

    pSrc = (*jenv)->GetPrimitiveArrayCritical(jenv, result, 0);
    if (!pSrc) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }
    memcpy(pSrc, blob, len);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, result, pSrc, 0);

    return result;
}

/* sqlite3_prepare by String[] */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1prepare_1v1(JNIEnv *jenv, jclass jcls, jlong db, jstring sql, jint nByte, jlong ppStmt, jobjectArray tailArray) {
    const char *zSql = NULL;
    char *pzTail = NULL;
    int result;
    
    if (sql) {
        zSql = (const char *)(*jenv)->GetStringUTFChars(jenv, sql, 0);
        if (!zSql) {
            return 0;
        }
    }
    result = sqlite3_prepare((sqlite3 *)_voidp(db), zSql, (int)nByte, (sqlite3_stmt **)_voidp(ppStmt), (const char **)(tailArray != NULL ? &pzTail : NULL));
    if (result == SQLITE_OK
            && (tailArray != NULL && (*jenv)->GetArrayLength(jenv, tailArray) != 0)) {
        jstring tail = (*jenv)->NewStringUTF(jenv, pzTail);
        if (!tail) {
            return 0;
        }
        (*jenv)->SetObjectArrayElement(jenv, tailArray, 0, tail);
    }
    if (zSql) {
        (*jenv)->ReleaseStringUTFChars(jenv, sql, zSql);
    }
    return (jint)result;
}

/* sqlite3_prepare_v2 by String[] */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1prepare_1v2(JNIEnv *jenv, jclass jcls, jlong db, jstring sql, jint nByte, jlong ppStmt, jobjectArray tailArray) {
    const char *zSql = NULL;
    char *pzTail = NULL;
    int result;
    
    if (sql) {
        zSql = (const char *)(*jenv)->GetStringUTFChars(jenv, sql, 0);
        if (!zSql) {
            return 0;
        }
    }
    result = sqlite3_prepare_v2((sqlite3 *)_voidp(db), zSql, (int)nByte, (sqlite3_stmt **)_voidp(ppStmt), (const char **)(tailArray != NULL ? &pzTail : NULL));
    if (result == SQLITE_OK
            && (tailArray != NULL && (*jenv)->GetArrayLength(jenv, tailArray) != 0)) {
        jstring tail = (*jenv)->NewStringUTF(jenv, pzTail);
        if (!tail) {
            return 0;
        }
        (*jenv)->SetObjectArrayElement(jenv, tailArray, 0, tail);
    }
    if (zSql) {
        (*jenv)->ReleaseStringUTFChars(jenv, sql, zSql);
    }
    return (jint)result;
}

/* get FieldID */
static int GetFieldID(JNIEnv *jenv, jfieldID *pFieldID, const char *className, const char *fieldName, const char *signature) {
    jclass clazz = (*jenv)->FindClass(jenv, className);
    if (clazz) {
        *pFieldID = (*jenv)->GetFieldID(jenv, clazz, fieldName, signature);
        if (*pFieldID) {
            return 1;
        }
    }
    return 0;
}

/* load 'org.sqlite.callback.Callback' class */
static int LoadCallbackClass(JNIEnv *jenv) {
    return (fid_callback_this
            || GetFieldID(jenv, &fid_callback_this, "org/sqlite/callback/Callback", "_this", "J"));
}

/* load 'org.sqlite.callback.NamedCallback' class */
static int LoadNamedCallbackClass(JNIEnv *jenv) {
    return (fid_namedcallback_name
            || (LoadCallbackClass(jenv)
                && GetFieldID(jenv, &fid_namedcallback_name, "org/sqlite/callback/NamedCallback", "name", "Ljava/lang/String;")));
}

/* load class */
static int LoadClass(JNIEnv *jenv, jclass *pClazz, const char* className) {
    if (*pClazz) {
        // already loaded
        return 1;
        
    } else {
        *pClazz = (*jenv)->FindClass(jenv, className);
        if (*pClazz) {
            *pClazz = (*jenv)->NewGlobalRef(jenv, *pClazz);
            return 1;
        }
    }
    return 0;
}

/* load 'org.sqlite.udf.Function' class */
static int LoadFunctionClass(JNIEnv *jenv) {
    if (fid_function_argc) {
        // alrealy loaded
        return 1;

    } else {
        if (LoadNamedCallbackClass(jenv)
                && LoadClass(jenv, &clsFunction, "org/sqlite/udf/Function")) {
            fid_function_argc = (*jenv)->GetFieldID(jenv, clsFunction, "argc", "I");
            if (fid_function_argc) {
                return 1;
            }
        }
    }
    return 0;
}

/* load 'org.sqlite.udf.AggregateFunction' class */
static int LoadAggregateFunctionClass(JNIEnv *jenv) {
    return (clsAggregateFunction
            || (LoadNamedCallbackClass(jenv)
                && LoadClass(jenv, &clsAggregateFunction, "org/sqlite/udf/AggregateFunction")));
}

/* load 'org.sqlite.text.Collator' class */
static int LoadCollatorClass(JNIEnv *jenv) {
    if (fid_collator_enc) {
        // alrealy loaded
        return 1;

    } else {
        if (LoadNamedCallbackClass(jenv)
                && LoadClass(jenv, &clsCollator, "org/sqlite/text/Collator")) {
            fid_collator_enc = (*jenv)->GetFieldID(jenv, clsCollator, "enc", "I");
            if (fid_collator_enc) {
                return 1;
            }
        }
    }
    return 0;
}

/* load 'org.sqlite.auth.Authorizer' class */
static int LoadAuthorizerClass(JNIEnv *jenv) {
    return (clsAuthorizer
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsAuthorizer, "org/sqlite/auth/Authorizer")));
}

/* load 'org.sqlite.event.BusyHandler' class */
static int LoadBusyHandlerClass(JNIEnv *jenv) {
    return (clsBusyHandler
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsBusyHandler, "org/sqlite/event/BusyHandler")));
}

/* load 'org.sqlite.event.CollationNeededHandler' class */
static int LoadCollationNeededHandlerClass(JNIEnv *jenv) {
    return (clsCollationNeededHandler
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsCollationNeededHandler, "org/sqlite/event/CollationNeededHandler")));
}

/* load 'org.sqlite.event.ProgressHandler' class */
static int LoadProgressHandlerClass(JNIEnv *jenv) {
    return (clsProgressHandler
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsProgressHandler, "org/sqlite/event/ProgressHandler")));
}

/* load 'org.sqlite.event.CommitHook' class */
static int LoadCommitHookClass(JNIEnv *jenv) {
    return (clsCommitHook
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsCommitHook, "org/sqlite/event/CommitHook")));
}

/* load 'org.sqlite.event.RollbackHook' class */
static int LoadRollbackHookClass(JNIEnv *jenv) {
    return (clsRollbackHook
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsRollbackHook, "org/sqlite/event/RollbackHook")));
}

/* load 'org.sqlite.event.UpdateHook' class */
static int LoadUpdateHookClass(JNIEnv *jenv) {
    return (clsUpdateHook
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsUpdateHook, "org/sqlite/event/UpdateHook")));
}

/* load 'org.sqlite.profiler.Profiler' class */
static int LoadProfilerClass(JNIEnv *jenv) {
    return (clsProfiler
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsProfiler, "org/sqlite/profiler/Profiler")));
}

/* load 'org.sqlite.profiler.Tracer' class */
static int LoadTracerClass(JNIEnv *jenv) {
    return (clsTracer
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsTracer, "org/sqlite/profiler/Tracer")));
}

/* load 'org.sqlite.callback.ExecCallback' class */
static int LoadExecCallbackClass(JNIEnv *jenv) {
    return (clsExecCallback
            || (LoadCallbackClass(jenv)
                && LoadClass(jenv, &clsExecCallback, "org/sqlite/callback/ExecCallback")));
}

/* structure for user-defined function and user-defined collating sequences */
typedef struct _JAVA_OBJECT {
    JavaVM *jvm;
    jobject obj;
} JAVA_OBJECT, *PJAVA_OBJECT;

/* allocate JAVA_OBJECT */
static PJAVA_OBJECT AllocJavaObject(JNIEnv *jenv, jobject obj) {
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (jobj) {
        jobj->obj = (*jenv)->NewGlobalRef(jenv, obj);
        (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
    }
    return jobj;
}

/* delete JAVA_OBJECT */
static void DeleteJavaObject(JNIEnv *jenv, PJAVA_OBJECT jobj) {
    (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
    free(jobj);
}

/* save JAVA_OBJECT pointer to org.sqlite.callback.Callback._this field */
static void SaveJavaObject(JNIEnv *jenv, PJAVA_OBJECT jobj) {
    (*jenv)->SetLongField(jenv, jobj->obj, fid_callback_this, _jlong(jobj));
}

/* save JAVA_OBJECT pointer to org.sqlite.callback.Callback._this field */
static void SaveOrDeleteJavaObject(int resultCode, JNIEnv *jenv, PJAVA_OBJECT jobj) {
    if (resultCode == SQLITE_OK) {
        SaveJavaObject(jenv, jobj);
    } else {
        DeleteJavaObject(jenv, jobj);
    }
}

/* load JAVA_OBJECT pointer from org.sqlite.callback.Callback._this field */
static PJAVA_OBJECT LoadJavaObject(JNIEnv *jenv, jobject obj) {
    jlong _this = (*jenv)->GetLongField(jenv, obj, fid_callback_this);
    if (_this) {
        return (PJAVA_OBJECT)_voidp(_this);
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not registered yet.");
        return NULL;
    }
}

/* returns non-zero if the JAVA_OBJECT already saved */
static int IsAlreadySavedJavaObject(JNIEnv *jenv, jobject obj) {
    if ((*jenv)->GetLongField(jenv, obj, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is already registered.");
        return 1;
    }
    return 0;
}

/* delete JAVA_OBJECT and 0 clearing of the _this field.  */
static void DeleteCallback(JNIEnv *jenv, PJAVA_OBJECT jobj) {
    (*jenv)->SetLongField(jenv, jobj->obj, fid_callback_this, 0);
    DeleteJavaObject(jenv, jobj);
}

/* get callback name from org.sqlite.callback.NamedCallback.name field */
static const char *GetCallbackName(JNIEnv *jenv, jobject obj, jstring *jname) {
    // get name value
    *jname = (jstring)(*jenv)->GetObjectField(jenv, obj, fid_namedcallback_name);
    if (*jname) {
        return (const char *)(*jenv)->GetStringUTFChars(jenv, *jname, 0);
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "name is null.");
    }
    return NULL;
}

/* AttachCurrentThread */
static int AttachCurrentThread(PJAVA_OBJECT jobj, JNIEnv **pjenv) {
    int result = (int)(*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)pjenv, (void *)0);
    if (result != JNI_OK) {
        JavaThrowException(*pjenv, "java/lang/InternalError", "Failed AttachCurrentThread().");
    }
    return result;
}

/* User-Defined Function */
static void xFunc(sqlite3_context* ctx, int argc, sqlite3_value** value) {
    static jmethodID mid_xFunc = 0;
    JNIEnv *jenv = NULL;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)sqlite3_user_data(ctx);
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xFunc) {
        mid_xFunc = (*jenv)->GetMethodID(jenv, clsFunction, "xFunc", "(JIJ)V");
        if (!mid_xFunc) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xFunc, _jlong(ctx), argc, _jlong(value));
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

static void xFinal(sqlite3_context* ctx) {
    static jmethodID mid_xFinal = 0;
    JNIEnv *jenv = NULL;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)sqlite3_user_data(ctx);

    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xFinal) {
        mid_xFinal = (*jenv)->GetMethodID(jenv, clsAggregateFunction, "xFinal", "(J)V");
        if (!mid_xFinal) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xFinal, _jlong(ctx));
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_create_function by org.sqlite.udf.Function */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1create_1function(JNIEnv *jenv, jclass jcls, jlong db, jobject func) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    const char *name = NULL;
    jint argc = 0;
    int isAgFunc = 0;
    int result;

    if (!clsFunction && !LoadFunctionClass(jenv)) {
        // not found 'org.sqlite.udf.Function' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, func, clsFunction)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.udf.Function'.");
        return 0;
    }
    
    if (!clsAggregateFunction && !LoadAggregateFunctionClass(jenv)) {
        // not found 'org.sqlite.udf.AggregateFunction' class
        return 0;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, func)) {
        return 0;
    }

    // get org.sqlite.udf.Function.name value
    name = GetCallbackName(jenv, func, &jname);
    if (!(name && jname)) {
        return 0;
    }
    
    // get org.sqlite.udf.Function.argc value
    argc = (*jenv)->GetIntField(jenv, func, fid_function_argc);

    // allocate user data
    jobj = AllocJavaObject(jenv, func);
    if (!jobj) {
        return 0;
    }
    
    // func insetanceof org.sqlite.udf.AggregateFunction
    isAgFunc = (*jenv)->IsInstanceOf(jenv, func, clsAggregateFunction);
    
    // register function
    result = sqlite3_create_function((sqlite3 *)_voidp(db), name, (int)argc, SQLITE_UTF8, jobj, (isAgFunc ? NULL : &xFunc), (isAgFunc ? &xFunc : NULL), (isAgFunc ? &xFinal : NULL));
    
    // save JAVA_OBJECT to _this field
    SaveOrDeleteJavaObject(result, jenv, jobj);

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, name);
    }

    return (jint)result;
}

/* sqlite3_create_function by org.sqlite.udf.Function */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1drop_1function(JNIEnv *jenv, jclass jcls, jlong db, jobject func) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    const char *name = NULL;
    int result;

    if (!clsFunction && !LoadFunctionClass(jenv)) {
        // not found 'org.sqlite.udf.Function' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, func, clsFunction)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.udf.Function'.");
        return 0;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, func);
    if (!jobj) {
        return 0;
    }

    // get org.sqlite.udf.Function.name value
    name = GetCallbackName(jenv, func, &jname);
    if (!(name && jname)) {
        return 0;
    }

    // unregister function
    result = sqlite3_create_function((sqlite3 *)_voidp(db), name, -1, SQLITE_UTF8, NULL, NULL, NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (result == SQLITE_OK) {
        DeleteCallback(jenv, jobj);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    return (jint)result;
}

static int xCompare(void *p, int len1, const void *str1, int len2, const void *str2) {
    static jmethodID mid_compare = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jstring source = NULL;
    jstring target = NULL;
    char *str;
    jint jresult;

    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_compare) {
        mid_compare = (*jenv)->GetMethodID(jenv, clsCollator, "compare", "(Ljava/lang/Object;Ljava/lang/Object;)I");
        if (!mid_compare) {
            return 0;
        }
    }

    str = (char *)calloc(len1 + 1, sizeof(char));
    if (!str) {
        return 0;
    }
    strncpy(str, str1, len1);
    str[len1] = '\0';
    source = (*jenv)->NewStringUTF(jenv, (const char*)str);
    free(str);
    if (!source) {
        return 0;
    }

    str = (char *)calloc(len2 + 1, sizeof(char));
    if (!str) {
        return 0;
    }
    strncpy(str, str2, len2);
    str[len2] = '\0';
    target = (*jenv)->NewStringUTF(jenv, (const char*)str);
    free(str);
    if (!target) {
        return 0;
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_compare, source, target);

    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);

    return (int)jresult;
}

static int xCompare16(void *p, int len1, const void *str1, int len2, const void *str2) {
    static jmethodID mid_xCompare = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jbyteArray source = NULL;
    jbyteArray target = NULL;
    jbyte *b;
    jint jresult;

    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xCompare) {
        mid_xCompare = (*jenv)->GetMethodID(jenv, clsCollator, "xCompare", "([B[B)I");
        if (!mid_xCompare) {
            return 0;
        }
    }

    source = (*jenv)->NewByteArray(jenv, (jsize)len1);
    if (!source) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return 0;
    }
    b = (*jenv)->GetPrimitiveArrayCritical(jenv, source, 0);
    if (!b) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return 0;
    }
    memcpy(b, str1, len1);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, source, b, 0);

    target = (*jenv)->NewByteArray(jenv, (jsize)len2);
    if (!target) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return 0;
    }
    b = (*jenv)->GetPrimitiveArrayCritical(jenv, target, 0);
    if (!b) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return 0;
    }
    memcpy(b, str2, len2);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, target, b, 0);

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xCompare, source, target);

    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);

    return (int)jresult;
}

/* sqlite3_create_collation by org.sqlite.text.Collator */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1create_1collation(JNIEnv *jenv, jclass jcls, jlong db, jobject col) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    const char *name = NULL;
    int eTextRep;
    int result;

    if (!clsCollator && !LoadCollatorClass(jenv)) {
        // not found 'org.sqlite.text.Collator' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, col, clsCollator)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.text.Collator'.");
        return 0;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, col)) {
        return 0;
    }

    // get org.sqlite.text.Collator.name value
    name = GetCallbackName(jenv, col, &jname);
    if (!(name && jname)) {
        return 0;
    }

    // get org.sqlite.text.Collator.enc value
    eTextRep = (*jenv)->GetIntField(jenv, col, fid_collator_enc);

    // allocate user data
    jobj = AllocJavaObject(jenv, col);
    if (!jobj) {
        return 0;
    }
    
    // register collation sequence
    result = sqlite3_create_collation((sqlite3 *)_voidp(db), name, eTextRep, jobj, (eTextRep == SQLITE_UTF8 ? &xCompare : &xCompare16));

    // save JAVA_OBJECT to _this field
    SaveOrDeleteJavaObject(result, jenv, jobj);

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, name);
    }

    return (jint)result;
}

/* sqlite3_create_collation by org.sqlite.text.Collator */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1drop_1collation(JNIEnv *jenv, jclass jcls, jlong db, jobject col) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    const char *name = NULL;
    int eTextRep;
    int result;

    if (!clsCollator && !LoadCollatorClass(jenv)) {
        // not found 'org.sqlite.text.Collator' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, col, clsCollator)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.text.Collator'.");
        return 0;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, col);
    if (!jobj) {
        return 0;
    }

    // get org.sqlite.text.Collator.name value
    name = GetCallbackName(jenv, col, &jname);
    if (!(name && jname)) {
        return 0;
    }

    // get org.sqlite.text.Collator.enc value
    eTextRep = (*jenv)->GetIntField(jenv, col, fid_collator_enc);

    // unregister collation sequence
    result = sqlite3_create_collation((sqlite3 *)_voidp(db), name, eTextRep, NULL, NULL);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (result == SQLITE_OK) {
        DeleteCallback(jenv, jobj);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    return (jint)result;
}

static int xAuth(void *p, int action, const char *param3, const char *param4, const char* database, const char* triggerOrView) {
    static jmethodID mid_xAuth = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jstring jstr1 = NULL;
    jstring jstr2 = NULL;
    jstring jdatabase = NULL;
    jstring jtriggerOrView = NULL;    
    jint jresult;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xAuth) {
        mid_xAuth = (*jenv)->GetMethodID(jenv, clsAuthorizer, "xAuth", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        if (!mid_xAuth) {
            return 0;
        }
    }

    if (param3) {
        jstr1 = (*jenv)->NewStringUTF(jenv, param3);        
        if (!jstr1) {
            return 0;
        }
    }
    if (param4) {
        jstr2 = (*jenv)->NewStringUTF(jenv, param4);        
        if (!jstr2) {
            return 0;
        }
    }
    if (database) {
        jdatabase = (*jenv)->NewStringUTF(jenv, database);        
        if (!jdatabase) {
            return 0;
        }
    }
    if (triggerOrView) {
        jtriggerOrView = (*jenv)->NewStringUTF(jenv, triggerOrView);        
        if (!jtriggerOrView) {
            return 0;
        }
    }
    
    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xAuth, (jint)action, jstr1, jstr2, jdatabase, jtriggerOrView);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return (int)jresult;
}

/* sqlite3_set_authorizer by org.sqlite.auth.Authorizer */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1set_1authorizer(JNIEnv *jenv, jclass jcls, jlong db, jobject auth) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsAuthorizer && !LoadAuthorizerClass(jenv)) {
        // not found 'org.sqlite.auth.Authorizer' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, auth, clsAuthorizer)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.auth.Authorizer'.");
        return 0;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, auth)) {
        return 0;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, auth);
    if (!jobj) {
        return 0;
    }
    
    // set authorizer
    result = sqlite3_set_authorizer((sqlite3 *)_voidp(db), &xAuth, jobj);

    // save JAVA_OBJECT to _this field
    SaveOrDeleteJavaObject(result, jenv, jobj);

    return (jint)result;
}

/* sqlite3_set_authorizer by org.sqlite.auth.Authorizer */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1authorizer(JNIEnv *jenv, jclass jcls, jlong db, jobject auth) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsAuthorizer && !LoadAuthorizerClass(jenv)) {
        // not found 'org.sqlite.auth.Authorizer' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, auth, clsAuthorizer)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.auth.Authorizer'.");
        return 0;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, auth);
    if (!jobj) {
        return 0;
    }

    // clear authorizer
    result = sqlite3_set_authorizer((sqlite3 *)_voidp(db), NULL, NULL);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (result == SQLITE_OK) {
        DeleteCallback(jenv, jobj);
    }

    return (jint)result;
}

static int xBusy(void *p, int count) {
    static jmethodID mid_xBusy = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jresult;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xBusy) {
        mid_xBusy = (*jenv)->GetMethodID(jenv, clsBusyHandler, "xBusy", "(I)I");
        if (!mid_xBusy) {
            return 0;
        }
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xBusy, (jint)count);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return (int)jresult;
}

/* sqlite3_busy_handler by org.sqlite.event.BusyHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1busy_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject busy) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsBusyHandler && !LoadBusyHandlerClass(jenv)) {
        // not found 'org.sqlite.event.BusyHandler' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, busy, clsBusyHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.BusyHandler'.");
        return 0;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, busy)) {
        return 0;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, busy);
    if (!jobj) {
        return 0;
    }
    
    // set busy handler
    result = sqlite3_busy_handler((sqlite3 *)_voidp(db), &xBusy, jobj);

    // save JAVA_OBJECT to _this field
    SaveOrDeleteJavaObject(result, jenv, jobj);

    return (jint)result;
}

/* sqlite3_busy_handler by org.sqlite.event.BusyHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1busy_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject busy) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsBusyHandler && !LoadBusyHandlerClass(jenv)) {
        // not found 'org.sqlite.event.BusyHandler' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, busy, clsBusyHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.BusyHandler'.");
        return 0;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, busy);
    if (!jobj) {
        return 0;
    }

    // clear busy handler
    result = sqlite3_busy_handler((sqlite3 *)_voidp(db), NULL, NULL);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (result == SQLITE_OK) {
        DeleteCallback(jenv, jobj);
    }

    return (jint)result;
}

static void xCollationNeeded(void *p, sqlite3 *pDb, int eTextRep, const char* name) {
    static jmethodID mid_xCollationNeeded = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jstring jname = NULL;

    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xCollationNeeded) {
        mid_xCollationNeeded = (*jenv)->GetMethodID(jenv, clsCollationNeededHandler, "xCollationNeeded", "(JILjava/lang/String;)V");
        if (!mid_xCollationNeeded) {
            return;
        }
    }

    if (name) {
        jname = (*jenv)->NewStringUTF(jenv, name);        
        if (!jname) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xCollationNeeded, _jlong(pDb), (jint)eTextRep, jname);

    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_collation_needed by org.sqlite.event.CollationNeededHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1collation_1needed(JNIEnv *jenv, jclass jcls, jlong db, jobject needed) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsCollationNeededHandler && !LoadCollationNeededHandlerClass(jenv)) {
        // not found 'org.sqlite.event.CollationNeededHandler' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, needed, clsCollationNeededHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.CollationNeededHandler'.");
        return 0;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, needed)) {
        return 0;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, needed);
    if (!jobj) {
        return 0;
    }
    
    // set collation needed handler
    result = sqlite3_collation_needed((sqlite3 *)_voidp(db), jobj, &xCollationNeeded);

    // save JAVA_OBJECT to _this field
    SaveOrDeleteJavaObject(result, jenv, jobj);

    return (jint)result;
}

/* sqlite3_collation_needed by org.sqlite.event.CollationNeededHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1collation_1needed(JNIEnv *jenv, jclass jcls, jlong db, jobject needed) {
    PJAVA_OBJECT jobj = NULL;
    int result;

    if (!clsCollationNeededHandler && !LoadCollationNeededHandlerClass(jenv)) {
        // not found 'org.sqlite.event.CollationNeededHandler' class
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, needed, clsCollationNeededHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.CollationNeededHandler'.");
        return 0;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, needed);
    if (!jobj) {
        return 0;
    }

    // clear collation needed handler
    result = sqlite3_collation_needed((sqlite3 *)_voidp(db), NULL, NULL);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (result == SQLITE_OK) {
        DeleteCallback(jenv, jobj);
    }

    return (jint)result;
}

static int xProgress(void *p) {
    static jmethodID mid_xProgress = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jresult;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xProgress) {
        mid_xProgress = (*jenv)->GetMethodID(jenv, clsProgressHandler, "xProgress", "()I");
        if (!mid_xProgress) {
            return 0;
        }
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xProgress);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return (int)jresult;
}

/* sqlite3_progress_handler by org.sqlite.event.ProgressHandler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1progress_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject prog) {
    static jfieldID fid_progresshandler_opecodes = 0;
    jint opecodes = 0;
    PJAVA_OBJECT jobj = NULL;

    if (!clsProgressHandler) {
        if (!LoadProgressHandlerClass(jenv)) {
            // not found 'org.sqlite.event.ProgressHandler' class
            return;
        }
        fid_progresshandler_opecodes = (*jenv)->GetFieldID(jenv, clsProgressHandler, "opecodes", "I");
        if (!fid_progresshandler_opecodes) {
            return;
        }
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, prog, clsProgressHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.ProgressHandler'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, prog)) {
        return;
    }

    // get org.sqlite.event.ProgressHandler.opecodes value
    opecodes = (*jenv)->GetIntField(jenv, prog, fid_progresshandler_opecodes);
    
    // allocate user data
    jobj = AllocJavaObject(jenv, prog);
    if (!jobj) {
        return;
    }
    
    // set progress handler
    sqlite3_progress_handler((sqlite3 *)_voidp(db), (int)opecodes, &xProgress, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);
}

/* sqlite3_progress_handler by org.sqlite.event.ProgressHandler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1progress_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject prog) {
    PJAVA_OBJECT jobj = NULL;

    if (!clsProgressHandler && !LoadProgressHandlerClass(jenv)) {
        // not found 'org.sqlite.event.ProgressHandler' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, prog, clsProgressHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.ProgressHandler'.");
        return;
    }

    // load JAVA_OBJECT from _this field
    jobj = LoadJavaObject(jenv, prog);
    if (!jobj) {
        return;
    }

    // clear progress handler
    sqlite3_progress_handler((sqlite3 *)_voidp(db), 0, NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    DeleteCallback(jenv, jobj);
}

static int xCommit(void *p) {
    static jmethodID mid_xCommit = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jresult;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xCommit) {
        mid_xCommit = (*jenv)->GetMethodID(jenv, clsCommitHook, "xCommit", "()I");
        if (!mid_xCommit) {
            return 0;
        }
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xCommit);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return (int)jresult;
}

/* sqlite3_commit_hook by org.sqlite.event.CommitHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1commit_1hook(JNIEnv *jenv, jclass jcls, jlong db, jobject hook) {
    PJAVA_OBJECT jobj = NULL;
    void *pOld = NULL;

    if (!clsCommitHook && !LoadCommitHookClass(jenv)) {
        // not found 'org.sqlite.event.CommitHook' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, hook, clsCommitHook)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.CommitHook'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, hook)) {
        return;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, hook);
    if (!jobj) {
        return;
    }
    
    // set commit hook
    pOld = sqlite3_commit_hook((sqlite3 *)_voidp(db), &xCommit, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

/* sqlite3_commit_hook by org.sqlite.event.CommitHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1commit_1hook(JNIEnv *jenv, jclass jcls, jlong db) {
    // clear commit hook
    void *pOld = sqlite3_commit_hook((sqlite3 *)_voidp(db), NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

static void xRollback(void *p) {
    static jmethodID mid_xRollback = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xRollback) {
        mid_xRollback = (*jenv)->GetMethodID(jenv, clsRollbackHook, "xRollback", "()V");
        if (!mid_xRollback) {
            return;
        }
    }

    (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xRollback);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_rollback_hook by org.sqlite.event.RollbackHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1rollback_1hook(JNIEnv *jenv, jclass jcls, jlong db, jobject hook) {
    PJAVA_OBJECT jobj = NULL;
    void *pOld = NULL;

    if (!clsRollbackHook && !LoadRollbackHookClass(jenv)) {
        // not found 'org.sqlite.event.RollbackHook' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, hook, clsRollbackHook)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.RollbackHook'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, hook)) {
        return;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, hook);
    if (!jobj) {
        return;
    }
    
    // set rollback hook
    pOld = sqlite3_rollback_hook((sqlite3 *)_voidp(db), &xRollback, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

/* sqlite3_rollback_hook by org.sqlite.event.RollbackHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1rollback_1hook(JNIEnv *jenv, jclass jcls, jlong db) {
    // clear rollback hook
    void *pOld = sqlite3_rollback_hook((sqlite3 *)_voidp(db), NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

static void xUpdate(void *p, int action, char const *dbName, char const *tableName, sqlite_int64 rowid) {
    static jmethodID mid_xUpdate = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    jstring jdbName = NULL;
    jstring jtableName = NULL;
    JNIEnv *jenv = NULL;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xUpdate) {
        mid_xUpdate = (*jenv)->GetMethodID(jenv, clsUpdateHook, "xUpdate", "(ILjava/lang/String;Ljava/lang/String;J)V");
        if (!mid_xUpdate) {
            return;
        }
    }

    if (dbName) {
        jdbName = (*jenv)->NewStringUTF(jenv, dbName);        
        if (!jdbName) {
            return;
        }
    }
    if (tableName) {
        jtableName = (*jenv)->NewStringUTF(jenv, tableName);        
        if (!jtableName) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xUpdate, (jint)action, jdbName, jtableName, (jlong)rowid);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_update_hook by org.sqlite.event.UpdateHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1update_1hook(JNIEnv *jenv, jclass jcls, jlong db, jobject hook) {
    PJAVA_OBJECT jobj = NULL;
    void *pOld = NULL;

    if (!clsUpdateHook && !LoadUpdateHookClass(jenv)) {
        // not found 'org.sqlite.event.UpdateHook' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, hook, clsUpdateHook)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.event.UpdateHook'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, hook)) {
        return;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, hook);
    if (!jobj) {
        return;
    }
    
    // set update hook
    pOld = sqlite3_update_hook((sqlite3 *)_voidp(db), &xUpdate, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

/* sqlite3_update_hook by org.sqlite.event.UpdateHook */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1update_1hook(JNIEnv *jenv, jclass jcls, jlong db) {
    // clear update hook
    void *pOld = sqlite3_update_hook((sqlite3 *)_voidp(db), NULL, NULL);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

static void xProfile(void *p, char const *szSql, sqlite_uint64 elapseTime) {
    static jmethodID mid_xProfile = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    jstring jsql = NULL;
    JNIEnv *jenv = NULL;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xProfile) {
        mid_xProfile = (*jenv)->GetMethodID(jenv, clsProfiler, "xProfile", "(Ljava/lang/String;J)V");
        if (!mid_xProfile) {
            return;
        }
    }

    if (szSql) {
        jsql = (*jenv)->NewStringUTF(jenv, szSql);        
        if (!jsql) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xProfile, jsql, (jlong)elapseTime);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_profile by org.sqlite.profiler.Profiler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1profile(JNIEnv *jenv, jclass jcls, jlong db, jobject prof) {
    PJAVA_OBJECT jobj = NULL;
    void *pOld = NULL;

    if (!clsProfiler && !LoadProfilerClass(jenv)) {
        // not found 'org.sqlite.profiler.Profiler' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, prof, clsProfiler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.profiler.Profiler'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, prof)) {
        return;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, prof);
    if (!jobj) {
        return;
    }
    
    // set profiler
    pOld = sqlite3_profile((sqlite3 *)_voidp(db), &xProfile, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

/* sqlite3_profile by org.sqlite.profiler.Profiler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1profile(JNIEnv *jenv, jclass jcls, jlong db) {
    // clear profiler
    void *pOld = sqlite3_profile((sqlite3 *)_voidp(db), NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

static void xTrace(void *p, char const *szSql) {
    static jmethodID mid_xTrace = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    jstring jsql = NULL;
    JNIEnv *jenv = NULL;
    
    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return;
    }

    if (!mid_xTrace) {
        mid_xTrace = (*jenv)->GetMethodID(jenv, clsTracer, "xTrace", "(Ljava/lang/String;)V");
        if (!mid_xTrace) {
            return;
        }
    }

    if (szSql) {
        jsql = (*jenv)->NewStringUTF(jenv, szSql);        
        if (!jsql) {
            return;
        }
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xTrace, jsql);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_trace by org.sqlite.profiler.Tracer */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1trace(JNIEnv *jenv, jclass jcls, jlong db, jobject tracer) {
    PJAVA_OBJECT jobj = NULL;
    void *pOld = NULL;

    if (!clsTracer && !LoadTracerClass(jenv)) {
        // not found 'org.sqlite.profiler.Tracer' class
        return;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, tracer, clsTracer)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.profiler.Tracer'.");
        return;
    }

    // check already registered
    if (IsAlreadySavedJavaObject(jenv, tracer)) {
        return;
    }

    // allocate user data
    jobj = AllocJavaObject(jenv, tracer);
    if (!jobj) {
        return;
    }
    
    // set tracer
    pOld = sqlite3_trace((sqlite3 *)_voidp(db), &xTrace, jobj);

    // save JAVA_OBJECT to _this field
    SaveJavaObject(jenv, jobj);

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

/* sqlite3_trace by org.sqlite.profiler.Tracer */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1trace(JNIEnv *jenv, jclass jcls, jlong db) {
    // clear profiler
    void *pOld = sqlite3_trace((sqlite3 *)_voidp(db), NULL, NULL);
    
    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (pOld) {
        DeleteCallback(jenv, (PJAVA_OBJECT)pOld);
    }
}

static void xDelete(void *p) {
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    if (AttachCurrentThread(jobj, &jenv) == JNI_OK) {
        DeleteJavaObject(jenv, jobj);
    }
}

/* sqlite3_set_auxdata by java.lang.Object */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1set_1auxdata(JNIEnv *jenv, jclass jcls, jlong ctx, jint n, jobject obj) {
    // allocate user data
    PJAVA_OBJECT jobj = AllocJavaObject(jenv, obj);
    if (jobj) {
        // set auxiliary data
        sqlite3_set_auxdata((sqlite3_context *)_voidp(ctx), (int)n, jobj, &xDelete);
    }
}

/* sqlite3_get_auxdata by java.lang.Object */
JNIEXPORT jobject JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1auxdata(JNIEnv *jenv, jclass jcls, jlong ctx, jint n) {
    // get auxiliary data
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)sqlite3_get_auxdata((sqlite3_context *)_voidp(ctx), (int)n);

    return (jobj ? jobj->obj : NULL);
}

/* set sqlite3_temp_directory */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_set_1sqlite3_1temp_1directory(JNIEnv *jenv, jclass jcls, jstring path) {
    const char *szPath = NULL;
    if (path) {
        szPath = (const char *)(*jenv)->GetStringUTFChars(jenv, path, 0);
        if (!szPath) {
            return;
        }
    }
    if (sqlite3_temp_directory) {
        free(sqlite3_temp_directory);
    }
    if (szPath) {
        sqlite3_temp_directory = (char *)calloc(strlen(szPath) + 1, sizeof(char));
        strcpy(sqlite3_temp_directory, szPath);
        (*jenv)->ReleaseStringUTFChars(jenv, path, szPath);
    } else {
        sqlite3_temp_directory = 0;
    }
}

static int xCallback(void *p, int cnt, char **pszValues, char **pszColumnNames) {
    static jmethodID mid_xCallback = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jclass clsString = NULL;
    jobjectArray values;
    jobjectArray columnNames;
    int i;
    int result;

    if (AttachCurrentThread(jobj, &jenv) != JNI_OK) {
        return 0;
    }

    if (!mid_xCallback) {
        mid_xCallback = (*jenv)->GetMethodID(jenv, clsExecCallback, "xCallback", "([Ljava/lang/String;[Ljava/lang/String;)I");
        if (!mid_xCallback) {
            return 0;
        }
    }

    clsString = (*jenv)->FindClass(jenv, "java/lang/String");
    if (!clsString) {
        return 0;
    }

    values = (*jenv)->NewObjectArray(jenv, (jsize)cnt, clsString, NULL);
    columnNames = (*jenv)->NewObjectArray(jenv, (jsize)cnt, clsString, NULL);
    for (i = 0; i < cnt; ++i) {
        jstring val = (*jenv)->NewStringUTF(jenv, pszValues[i]);
        if (!val) {
            return 0;
        }
        (*jenv)->SetObjectArrayElement(jenv, values, i, val);

        val = (*jenv)->NewStringUTF(jenv, pszColumnNames[i]);
        if (!val) {
            return 0;
        }
        (*jenv)->SetObjectArrayElement(jenv, columnNames, i, val);
    }

    result = (int)(*jenv)->CallIntMethod(jenv, jobj->obj, mid_xCallback, values, columnNames);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);

    return result;
}

/* sqlite3_exec by org.sqlite.callback.ExecCallback */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1exec(JNIEnv *jenv, jclass jcls, jlong db, jstring sql, jobject callback, jlong errmsg) {
    PJAVA_OBJECT jobj = NULL;
    const char *zSql = NULL;
    int result;

    if (callback) {
        if (!clsExecCallback && !LoadExecCallbackClass(jenv)) {
            // not found 'org.sqlite.callback.ExecCallback' class
            return 0;
        }

        // validate instance
        if (!(*jenv)->IsInstanceOf(jenv, callback, clsExecCallback)) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'org.sqlite.callback.ExecCallback'.");
            return 0;
        }

        // check already registered
        if (IsAlreadySavedJavaObject(jenv, callback)) {
            return 0;
        }

        // allocate user data
        jobj = AllocJavaObject(jenv, callback);
        if (!jobj) {
            return 0;
        }

        // save JAVA_OBJECT to _this field
        SaveJavaObject(jenv, jobj);
    }

    if (sql) {
        zSql = (const char *)(*jenv)->GetStringUTFChars(jenv, sql, 0);
        if (!zSql) {
            return 0;
        }
    }

    // sqlite3_exec
    result = sqlite3_exec((sqlite3 *)_voidp(db), zSql, (callback ? &xCallback : NULL), jobj, (errmsg ? (char **)_voidp(errmsg) : NULL));

    if (zSql) {
        (*jenv)->ReleaseStringUTFChars(jenv, sql, zSql);
    }

    // delete JAVA_OBJECT and 0 clearing of the _this field.
    if (jobj) {
        DeleteCallback(jenv, jobj);
    }

    return (jint)result;
}

/* sqlite3_get_table by java.util.Collection */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1table(JNIEnv *jenv, jclass jcls, jlong db, jstring sql, jobject collection, jlong errmsg) {
    static jmethodID mid_add = 0;
    jclass clsCollection = NULL;
    const char *zSql = NULL;
    char **pResult = NULL;
    int nrow;
    int ncolumn;
    int result;

    // load Collection interface
    if (!LoadClass(jenv, &clsCollection, "java/util/Collection")) {
        // not found 'java.util.Collection' interface
        return 0;
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, collection, clsCollection)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "object is not instanceof 'java.util.Collection'.");
        return 0;
    }

    if (!mid_add) {
        mid_add = (*jenv)->GetMethodID(jenv, clsCollection, "add", "(Ljava/lang/Object;)Z");
        if (!mid_add) {
            return 0;
        }
    }

    if (sql) {
        zSql = (const char *)(*jenv)->GetStringUTFChars(jenv, sql, 0);
        if (!zSql) {
            return 0;
        }
    }

    // sqlite3_get_table
    result = sqlite3_get_table((sqlite3 *)_voidp(db), zSql, &pResult, &nrow, &ncolumn, (errmsg ? (char **)_voidp(errmsg) : NULL));

    if (zSql) {
        (*jenv)->ReleaseStringUTFChars(jenv, sql, zSql);
    }

    if (result == SQLITE_OK) {
        jclass clsString = (*jenv)->FindClass(jenv, "java/lang/String");
        if (clsString) {
            int i;
            for (i = 0; i <= nrow; ++i) {
                int j;
                jobjectArray values = (*jenv)->NewObjectArray(jenv, (jsize)ncolumn, clsString, NULL);
                for (j = 0; j < ncolumn; ++j) {
                    jstring val = (*jenv)->NewStringUTF(jenv, (const char *)pResult[(i * ncolumn) + j]);
                    if (!val) {
                        break;
                    }
                    (*jenv)->SetObjectArrayElement(jenv, values, j, val);
                }

                (*jenv)->CallBooleanMethod(jenv, collection, mid_add, values);
                if ((*jenv)->ExceptionCheck(jenv) == JNI_TRUE) {
                    break;
                }
            }
        }
    }

    // free memory
    sqlite3_free_table(pResult);

    return (jint)result;
}

#ifdef __cplusplus
}
#endif


static sqlite3* *new_p_p_sqlite3() { 
  return (sqlite3* *) calloc(1,sizeof(sqlite3*)); 
}

static sqlite3* *copy_p_p_sqlite3(sqlite3* value) { 
  sqlite3* *self = (sqlite3* *) calloc(1,sizeof(sqlite3*));
  *self = value;
  return self; 
}

static void delete_p_p_sqlite3(sqlite3* *self) { 
  if (self) free(self); 
}

static void p_p_sqlite3_assign(sqlite3* *self, sqlite3* value) {
  *self = value;
}

static sqlite3* p_p_sqlite3_value(sqlite3* *self) {
  return *self;
}


static sqlite3_stmt* *new_p_p_sqlite3_stmt() { 
  return (sqlite3_stmt* *) calloc(1,sizeof(sqlite3_stmt*)); 
}

static sqlite3_stmt* *copy_p_p_sqlite3_stmt(sqlite3_stmt* value) { 
  sqlite3_stmt* *self = (sqlite3_stmt* *) calloc(1,sizeof(sqlite3_stmt*));
  *self = value;
  return self; 
}

static void delete_p_p_sqlite3_stmt(sqlite3_stmt* *self) { 
  if (self) free(self); 
}

static void p_p_sqlite3_stmt_assign(sqlite3_stmt* *self, sqlite3_stmt* value) {
  *self = value;
}

static sqlite3_stmt* p_p_sqlite3_stmt_value(sqlite3_stmt* *self) {
  return *self;
}


static char* *new_p_p_char() { 
  return (char* *) calloc(1,sizeof(char*)); 
}

static char* *copy_p_p_char(char* value) { 
  char* *self = (char* *) calloc(1,sizeof(char*));
  *self = value;
  return self; 
}

static void delete_p_p_char(char* *self) { 
  if (self) free(self); 
}

static void p_p_char_assign(char* *self, char* value) {
  *self = value;
}

static char* p_p_char_value(char* *self) {
  return *self;
}


static int *new_p_int() { 
  return (int *) calloc(1,sizeof(int)); 
}

static int *copy_p_int(int value) { 
  int *self = (int *) calloc(1,sizeof(int));
  *self = value;
  return self; 
}

static void delete_p_int(int *self) { 
  if (self) free(self); 
}

static void p_int_assign(int *self, int value) {
  *self = value;
}

static int p_int_value(int *self) {
  return *self;
}


/* sqlite3_bind_blob by byte[] */
static int sqlite3_bind_blob_by_bytes(sqlite3_stmt *pStmt, int parameterIndex, char *BYTE, int length, void (*xDel)(void*)) {
    return sqlite3_bind_blob(pStmt, parameterIndex, BYTE, length, xDel);
}

/* sqlite3_column_blob by java.sql.Blob */
static void read_blob(const void *blob, long long pos, char *BYTE, int offset, int len) {
    memcpy(&BYTE[offset], &((const char *)blob)[pos], len);
}

/* get (sqlite3_value*)sqlite3_value**[i] */
static sqlite3_value* get_p_sqlite3_value(sqlite3_value** value, int i) {
    return value[i];
}

/* sqlite3_result_blob by byte[] */
static void sqlite3_result_blob_by_bytes(sqlite3_context *pCtx, char *BYTE, int length, void (*xDel)(void*)) {
    sqlite3_result_blob(pCtx, BYTE, length, xDel);
}

/* sqlite3_errmsg by int */
static const char *sqlite3_get_errmsg(int rc) {
    return sqlite3ErrStr(rc);
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1libversion(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)sqlite3_libversion();
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1libversion_1number(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sqlite3_libversion_number();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (int)sqlite3_close(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1extended_1result_1codes(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_extended_result_codes(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1last_1insert_1rowid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (sqlite_int64)sqlite3_last_insert_rowid(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1changes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (int)sqlite3_changes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1total_1changes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (int)sqlite3_total_changes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1interrupt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  sqlite3_interrupt(arg1);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1complete(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)sqlite3_complete((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1busy_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_busy_timeout(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1malloc(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (void *)sqlite3_malloc(arg1);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1realloc(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (void *)sqlite3_realloc(arg1,arg2);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1free(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void *arg1 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)_voidp(jarg1); 
  sqlite3_free(arg1);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1open(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  sqlite3 **arg2 = (sqlite3 **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (sqlite3 **)_voidp(jarg2); 
  result = (int)sqlite3_open((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1errcode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (int)sqlite3_errcode(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1errmsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (char *)sqlite3_errmsg(arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  void *arg3 = (void *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = (void *)_voidp(jarg3); 
  arg4 = (int)jarg4; 
  arg5 = (void (*)(void *))_voidp(jarg5); 
  result = (int)sqlite3_bind_blob(arg1,arg2,(void const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jdouble jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  double arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  result = (int)sqlite3_bind_double(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)sqlite3_bind_int(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite_int64 arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = (sqlite_int64)jarg3; 
  result = (int)sqlite3_bind_int64(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1null(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_bind_null(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = (void (*)(void *))_voidp(jarg5); 
  result = (int)sqlite3_bind_text(arg1,arg2,(char const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite3_value *arg3 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  arg3 = (sqlite3_value *)_voidp(jarg3); 
  result = (int)sqlite3_bind_value(arg1,arg2,(struct Mem const *)arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_bind_parameter_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_bind_parameter_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1index(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)sqlite3_bind_parameter_index(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1clear_1bindings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_clear_bindings(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_column_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1database_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_database_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1table_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_table_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1origin_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_origin_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1decltype(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_decltype(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1step(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_step(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1data_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_data_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (void *)sqlite3_column_blob(arg1,arg2);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_bytes(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1bytes16(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_bytes16(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jdouble jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (double)sqlite3_column_double(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_int(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (sqlite_int64)sqlite3_column_int64(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (unsigned char *)sqlite3_column_text(arg1,arg2);
  if (result) {
    jresult = (*jenv)->NewStringUTF(jenv, (const char *)result); 
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_type(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite3_value *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (sqlite3_value *)sqlite3_column_value(arg1,arg2);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1finalize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_finalize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_reset(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (void *)sqlite3_value_blob(arg1);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (int)sqlite3_value_bytes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1double(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (double)sqlite3_value_double(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1int(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (int)sqlite3_value_int(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (sqlite_int64)sqlite3_value_int64(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1text(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (unsigned char *)sqlite3_value_text(arg1);
  if (result) {
    jresult = (*jenv)->NewStringUTF(jenv, (const char *)result); 
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (int)sqlite3_value_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1numeric_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value *)_voidp(jarg1); 
  result = (int)sqlite3_value_numeric_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (void *)_voidp(jarg2); 
  arg3 = (int)jarg3; 
  arg4 = (void (*)(void *))_voidp(jarg4); 
  sqlite3_result_blob(arg1,(void const *)arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (double)jarg2; 
  sqlite3_result_double(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1error(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  sqlite3_result_error(arg1,(char const *)arg2,arg3);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1error_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  sqlite3_result_error_code(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  sqlite3_result_int(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  sqlite_int64 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (sqlite_int64)jarg2; 
  sqlite3_result_int64(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1null(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  sqlite3_result_null(arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  arg4 = (void (*)(void *))_voidp(jarg4); 
  sqlite3_result_text(arg1,(char const *)arg2,arg3,arg4);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  sqlite3_value *arg2 = (sqlite3_value *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  arg2 = (sqlite3_value *)_voidp(jarg2); 
  sqlite3_result_value(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1sleep(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)sqlite3_sleep(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1expired(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (int)sqlite3_expired(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1transfer_1bindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  sqlite3_stmt *arg2 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (sqlite3_stmt *)_voidp(jarg2); 
  result = (int)sqlite3_transfer_bindings(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1global_1recover(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sqlite3_global_recover();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1autocommit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  result = (int)sqlite3_get_autocommit(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1db_1handle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  sqlite3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  result = (sqlite3 *)sqlite3_db_handle(arg1);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1enable_1shared_1cache(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)sqlite3_enable_shared_cache(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1thread_1cleanup(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  sqlite3_thread_cleanup();
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1table_1column_1metadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char **arg5 = (char **) 0 ;
  char **arg6 = (char **) 0 ;
  int *arg7 = (int *) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (char **)_voidp(jarg5); 
  arg6 = (char **)_voidp(jarg6); 
  arg7 = (int *)_voidp(jarg7); 
  arg8 = (int *)_voidp(jarg8); 
  arg9 = (int *)_voidp(jarg9); 
  result = (int)sqlite3_table_column_metadata(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,(char const **)arg5,(char const **)arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1load_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char **arg4 = (char **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (char **)_voidp(jarg4); 
  result = (int)sqlite3_load_extension(arg1,(char const *)arg2,(char const *)arg3,arg4);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1enable_1load_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_enable_load_extension(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1auto_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)_voidp(jarg1); 
  result = (int)sqlite3_auto_extension(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1reset_1auto_1extension(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  sqlite3_reset_auto_extension();
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1sqlite3(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  sqlite3 **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (sqlite3 **)new_p_p_sqlite3();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1sqlite3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3 **arg1 = (sqlite3 **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 **)_voidp(jarg1); 
  delete_p_p_sqlite3(arg1);
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1p_1sqlite3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3 **arg1 = (sqlite3 **) 0 ;
  sqlite3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3 **)_voidp(jarg1); 
  result = (sqlite3 *)p_p_sqlite3_value(arg1);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  sqlite3_stmt **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (sqlite3_stmt **)new_p_p_sqlite3_stmt();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3_stmt **arg1 = (sqlite3_stmt **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt **)_voidp(jarg1); 
  delete_p_p_sqlite3_stmt(arg1);
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_stmt **arg1 = (sqlite3_stmt **) 0 ;
  sqlite3_stmt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt **)_voidp(jarg1); 
  result = (sqlite3_stmt *)p_p_sqlite3_stmt_value(arg1);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1char(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (char **)new_p_p_char();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1char(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  char **arg1 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char **)_voidp(jarg1); 
  delete_p_p_char(arg1);
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1p_1char(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  char **arg1 = (char **) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (char **)_voidp(jarg1); 
  result = (char *)p_p_char_value(arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1int(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (int *)new_p_int();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1int(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int *arg1 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int *)_voidp(jarg1); 
  delete_p_int(arg1);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1int(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int *)_voidp(jarg1); 
  result = (int)p_int_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jbyteArray jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_stmt *)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  {
    arg3 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg3, 0); 
  }
  arg4 = (int)jarg4; 
  arg5 = (void (*)(void *))_voidp(jarg5); 
  result = (int)sqlite3_bind_blob_by_bytes(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (jbyte *) arg3, 0); 
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_read_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jbyteArray jarg3, jint jarg4, jint jarg5) {
  void *arg1 = (void *) 0 ;
  long long arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (void *)_voidp(jarg1); 
  arg2 = (long long)jarg2; 
  {
    arg3 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg3, 0); 
  }
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  read_blob((void const *)arg1,arg2,arg3,arg4,arg5);
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (jbyte *) arg3, 0); 
  }
  
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1p_1sqlite3_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_value **arg1 = (sqlite3_value **) 0 ;
  int arg2 ;
  sqlite3_value *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_value **)_voidp(jarg1); 
  arg2 = (int)jarg2; 
  result = (sqlite3_value *)get_p_sqlite3_value(arg1,arg2);
  jresult = _jlong(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (sqlite3_context *)_voidp(jarg1); 
  {
    arg2 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg2, 0); 
  }
  arg3 = (int)jarg3; 
  arg4 = (void (*)(void *))_voidp(jarg4); 
  sqlite3_result_blob_by_bytes(arg1,arg2,arg3,arg4);
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (jbyte *) arg2, 0); 
  }
  
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1errmsg(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  int arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (char *)sqlite3_get_errmsg(arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


#ifdef __cplusplus
}
#endif

