package org.sqlite.profiler;

import org.sqlite.callback.Callback;

/**
 * SQL statement profiling class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/profile.html">Tracing And Profiling Functions</a>
 * @see org.sqlite.jdbc.JdbcConnection#setProfiler(Profiler)
 * @see org.sqlite.jdbc.JdbcConnection#clearProfiler()
 */
public abstract class Profiler extends Callback {

    /**
     * Called from the sqlite3_step() function.
     * @param sql SQL to be evaluated
     * @param elapseTime an estimate of wall-clock time of how long that statement took to execute
     */
    protected abstract void xProfile(String sql, long elapseTime);
}
