package org.sqlite.udf;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class ScalarFunctionTest {

    public ScalarFunctionTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test
    public void createFunction() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        try {
            final Function myFunc
                    = new ScalarFunction("myFunc") {
                            @Override
                            public void xFunc(Context ctx) throws SQLException {
                                System.out.printf("called xFunc(%s, %s)!\n", ctx.getString(1), ctx.getString(2));
                                String val = ctx.getString(2);
                                ctx.result(val);
                                
                                Object aux = null;

                                aux = ctx.getAuxData(1);
                                if (aux == null) {
                                    ctx.setAuxData(1, new String("1: Function Auxiliary Data"));
                                } else {
                                    System.out.println("1: aux is '" + aux + "'");
                                }
                                
                                 aux = ctx.getAuxData(2);
                                if (aux == null) {
                                    ctx.setAuxData(2, new String("2: Function Auxiliary Data"));
                                } else {
                                    System.out.println("2: aux is '" + aux + "'");
                                }
                                
                                aux = ctx.getAuxData(3);
                                if (aux == null) {
                                    ctx.setAuxData(3, new String("3: Function Auxiliary Data"));
                                } else {
                                    System.out.println("3: aux is '" + aux + "'");
                                }
                                
                                aux = ctx.getAuxData(4);
                                if (aux == null) {
                                    ctx.setAuxData(4, new String("4: Function Auxiliary Data"));
                                } else {
                                    System.out.println("4: aux is '" + aux + "'");
                                }
                            }
                        };
            assertFalse(myFunc.isRegistered());
            db.createFunction(myFunc);
            assertTrue(myFunc.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT myFunc('http://.*', N, 'ftp://.*', N) FROM ("
                        + "SELECT 'first' AS N UNION ALL "
                        + "SELECT 'second' AS N UNION ALL "
                        + "SELECT 'third' AS N UNION ALL "
                        + "SELECT 'fourth' AS N UNION ALL "
                        + "SELECT 'fifth' AS N UNION ALL "
                        + "SELECT 'sixth' AS N"
                    + ")";
            ResultSet rs = stmt.executeQuery(sql);
            assertTrue(rs.next());
            assertEquals("first", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("second", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("third", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("fourth", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("fifth", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("sixth", rs.getString(1));
            assertFalse(rs.next());
            rs.close();
            
            db.dropFunction(myFunc);
            assertFalse(myFunc.isRegistered());
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }
    }

    @Test(expected = java.sql.SQLException.class)
    public void dropFunction() throws ClassNotFoundException, SQLException {
        final Database db = newDatabase();
        try {
            final Function myFunc
                    = new ScalarFunction("myFunc") {
                            @Override
                            public void xFunc(Context ctx) {
                                System.out.println("called xFunc()!");
                            }
                        };
            assertFalse(myFunc.isRegistered());
            db.createFunction(myFunc);
            assertTrue(myFunc.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT myFunc('TEST') LIMIT 1");
            assertTrue(rs.next());
            assertNull(rs.getString(1));
            rs.close();
            
            db.dropFunction(myFunc);
            assertFalse(myFunc.isRegistered());

            rs = stmt.executeQuery("SELECT myFunc('TEST') LIMIT 1");
            rs.close();
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }
    }
}