/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.sqlite.Database;

/**
 *
 * @author calico
 */
public class JdbcStatement implements Statement {

    protected Database db;
    private final Connection owner;
    protected ResultSet rs;
    protected int cntUpdate = -1;
    protected List<String> batch;
    
    public JdbcStatement(Database db, Connection owner) {
        this.db = db;
        this.owner = owner;
    }
    
    // START implements
    public ResultSet executeQuery(String sql) throws SQLException {
        validateStatementOpen();

        final org.sqlite.Statement stmt = db.prepare(sql);
        validateStaticSQL(stmt);
        if (!stmt.producedResultSet()) {
            stmt.close();
            throw new SQLException("No ResultSet was produced.");
        }
        rs = new JdbcResultSet(this, stmt);
        cntUpdate = -1;
        return rs;
    }

    public int executeUpdate(String sql) throws SQLException {
        validateStatementOpen();

//        db.execute(sql);
        final org.sqlite.Statement stmt = db.prepare(sql);
        validateStaticSQL(stmt);
        if (stmt.producedResultSet()) {
            stmt.close();
            throw new SQLException("ResultSet was produced.");
        }
        stmt.step();
        cntUpdate = db.changes();
//        cntUpdate = db.totalChanges();
        rs = null;
        return cntUpdate;
    }

    public void close() throws SQLException {
        if (db != null) {
            db = null;
            if (rs != null) {
                rs.close();
                rs = null;
            }
            cntUpdate = -1;
            batch = null;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        validateStatementOpen();

        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMaxRows() throws SQLException {
        validateStatementOpen();

        return 0;
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getQueryTimeout() throws SQLException {
        validateStatementOpen();
        
        return (db.getBusyTimeout() / 1000);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        validateStatementOpen();
        
        db.setBusyTimeout(seconds * 1000);
    }

    public void cancel() throws SQLException {
        validateStatementOpen();

        db.interrupt();
    }

    public SQLWarning getWarnings() throws SQLException {
        validateStatementOpen();

        return null;
    }

    public void clearWarnings() throws SQLException {
        validateStatementOpen();

        // nothing
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql) throws SQLException {
        validateStatementOpen();

        return (executeQuery(sql) != null);
    }

    public ResultSet getResultSet() throws SQLException {
        validateStatementOpen();

        return rs;
    }

    public int getUpdateCount() throws SQLException {
        validateStatementOpen();

        return cntUpdate;
    }

    public boolean getMoreResults() throws SQLException {
        validateStatementOpen();

        if (rs != null) {
            rs.close();
            rs = null;
        }
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getFetchDirection() throws SQLException {
        validateStatementOpen();

        return ResultSet.FETCH_UNKNOWN;
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getFetchSize() throws SQLException {
        validateStatementOpen();

        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        validateStatementOpen();

        return ResultSet.CONCUR_READ_ONLY;
    }

    public int getResultSetType() throws SQLException {
        validateStatementOpen();

        return ResultSet.TYPE_SCROLL_INSENSITIVE;
    }

    public void addBatch(String sql) throws SQLException {
        validateStatementOpen();

        if (batch == null) {
            batch = new ArrayList<String>();
        }
        batch.add(sql);
    }

    public void clearBatch() throws SQLException {
        validateStatementOpen();

        batch = null;
    }

    public int[] executeBatch() throws SQLException {
        validateStatementOpen();

        if (batch == null) {
            return new int[0];
        }
        
        int[] ret = new int[batch.size()];
        BatchUpdateException ex = null;
        for (int i = 0; i < ret.length; ++i) {
            try {
                ret[i] = executeUpdate(batch.get(i));
            } catch (SQLException ex2) {
                if (ex == null) {
                    ex = new BatchUpdateException(ex2.getMessage(), ex2.getSQLState(), ex2.getErrorCode(), ret);
                }
                ret[i] = EXECUTE_FAILED;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public Connection getConnection() throws SQLException {
        validateStatementOpen();

        return owner;
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        validateAutoGeneretedKeys(autoGeneratedKeys);
        validateStatementOpen();

        return executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        validateAutoGeneretedKeys(autoGeneratedKeys);
        validateStatementOpen();

        return execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getResultSetHoldability() throws SQLException {
        validateStatementOpen();

        return ResultSet.CLOSE_CURSORS_AT_COMMIT;
    }

    public boolean isClosed() throws SQLException {
        return (db == null || db.isClosed());
    }
    // END implements

    @Override
    protected void finalize() throws Throwable {
        close();
        super.finalize();
    }
    
    protected void validateStatementOpen() throws SQLException {
        if (isClosed()) {
            throw new SQLException("Statement is already closed.");
        }
    }
    
    protected void validateStaticSQL(org.sqlite.Statement stmt) throws SQLException {
        if (stmt.getParameterCount() != 0) {
            stmt.close();
            throw new SQLException("Not static SQL.");            
        }
    }
    
    public static void validateAutoGeneretedKeys(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != NO_GENERATED_KEYS) {
            throw new SQLException("Not supported auto generated keys.");
        }    
    }
    
    /**
     * Statement#close()時にResultSetも一緒にcloseされないようにResultSetを切り離す。
     * @param drs
     */
    public void detach(ResultSet drs) throws SQLException {
        validateStatementOpen();

        if (rs != null && rs == drs) {
            rs = null;
        }
    }
}
