/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.SQLException;
import static org.sqlite.swig.SQLite3.*;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;

/**
 *
 * @author calico
 */
public class JdbcSQLException extends SQLException {
    public JdbcSQLException(SWIGTYPE_p_sqlite3 db) {
        this(sqlite3_errmsg(db), sqlite3_errcode(db));
    }

    public JdbcSQLException(SWIGTYPE_p_sqlite3_stmt stmt) {
        this(sqlite3_db_handle(stmt));
    }

    public JdbcSQLException(String reason, int vendorCode) {
        super(reason, getSQLState(vendorCode), vendorCode);
    }

    /**
     * Convert SQLite result codes to SQL/99 SQLSTATE codes.
     * @param errcode SQLite Result Codes
     * @return SQL/99 SQLSTATE codes.
     * @see <a href="http://www.sqlite.org/c3ref/c_abort.html">Result Codes</a>
     */
    public static String getSQLState(int errcode) {
        final String subclass = ("000" + errcode).substring(0, 3);
        switch (errcode) {
            case SQLITE_OK:
            case SQLITE_ROW:
            case SQLITE_DONE:
                return "00" + subclass;

            case SQLITE_ABORT:
            case SQLITE_INTERRUPT:
                return "02" + subclass;

            case SQLITE_ERROR:
            case SQLITE_INTERNAL:
            case SQLITE_PERM:
            case SQLITE_BUSY:
            case SQLITE_LOCKED:
            case SQLITE_NOMEM:
                return "HY" + subclass;

            case SQLITE_READONLY:
            case SQLITE_IOERR:
            case SQLITE_CORRUPT:
            case SQLITE_FULL:
            case SQLITE_EMPTY:
            case SQLITE_SCHEMA:
            case SQLITE_TOOBIG:
            case SQLITE_MISMATCH:
            case SQLITE_NOLFS:
            case SQLITE_AUTH:
            case SQLITE_FORMAT:
            case SQLITE_RANGE:
            case SQLITE_NOTADB:
                return "90" + subclass;

            case SQLITE_CONSTRAINT:
                return "23" + subclass;

            case SQLITE_CANTOPEN:
                return "08" + subclass;

            case SQLITE_MISUSE:
                return "42" + subclass;
        }
        return null;
    }

}
