/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Context;

/**
 * User-Defined aggregate function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 */
public abstract class AggregateFunction extends Function {
    public AggregateFunction(String name, int argc) {
        super(name, argc);
    }

    public AggregateFunction(String name) {
        super(name);
    }

    @Override
    protected final void xFunc(Context ctx) throws SQLException {
        xStep(ctx);
    }
    
    /**
     * Called from the sqlite3_step() function.
     * @param context
     * @param argc
     * @param value
     */
    private void xFinal(long context) {
        Context ctx = null;
        try {
            ctx = new Context(context);
            xFinal(ctx);
            
        } catch (Throwable th) {
            if (ctx != null) {
                final String msg = th.toString();
                ctx.resultError((msg != null ? msg : "unknown error."));
                
            } else {
                Logger.getLogger(AggregateFunction.class.getName()).fine("Exception occurred: " + th.toString());
            }
        }
    }
    
    public abstract void xStep(Context ctx) throws SQLException;

    public abstract void xFinal(Context ctx) throws SQLException;
}
