/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.text;

import java.util.Comparator;

/**
 * User-Defined Collating Sequences class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_collation.html">Define New Collating Sequences</a>
 * @see org.sqlite.jdbc.JdbcConnection#registerCollation(Collator)
 * @see org.sqlite.jdbc.JdbcConnection#unregisterCollation(Collator)
 */
public abstract class Collator implements Comparator<String> {
    protected final String name;

    /** pointer of myself */
    private volatile long _this;
    
    public Collator(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }
    
    public String getName() {
        return name;
    }
    
    public boolean isRegistered() {
        return (_this != 0);
    }

    /**
     * Called from the sqlite3_step() function.
     * @param str1
     * @param str2
     */
    protected final int xCompare(String str1, String str2) {
        // TODO Mysaifu JVMのBug#11980が解決したらアクセス修飾子をprivateに変更すること！
        // @see http://sourceforge.jp/tracker/index.php?func=detail&aid=11980&group_id=1890&atid=7027
        return compare(str1, str2);
    }
    
}
