import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.event.ProgressHandler;
import org.sqlite.jdbc.JdbcConnection;
import static org.sqlite.swig.SQLite3Constants.*;

public class ProgressHandlerExample {

    @org.junit.Test(expected = java.sql.SQLException.class)
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new progress handler
            final ProgressHandler handler
                    = new ProgressHandler(1) {
                            @Override
                            protected int xProgress() {
                                System.out.println("Called xProgress()");
                                // interrupt
                                return -1;
                            }
                        };

            // set progress handler
            conn.setProgressHandler(handler);

            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);

            sql = "SELECT * FROM temp_tbl_1";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            
            stmt.close();

            // clear progress handler
            conn.clearProgressHandler();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new ProgressHandlerExample().example();
    }
}
