import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.udf.Context;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.udf.Function;
import org.sqlite.udf.ScalarFunction;

public class ScalarFunctionExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new scalar function
            final Function strcat
                    = new ScalarFunction("strcat") {
                        @Override
                        protected void xFunc(Context ctx) throws SQLException {
                            if (!ctx.hasValues()) {
                                throw new IllegalArgumentException("argument is 0");
                            }

                            final StringBuilder ret = new StringBuilder();
                            for (int i = 0; i < ctx.getArgumentCount(); ++i) {
                                final int idx = i + 1;
                                ret.append(ctx.getString(idx));
                            }
                            ctx.result(ret.toString());
                        }
                    };

            // create function
            conn.createFunction(strcat);

            final Statement stmt = conn.createStatement();
            final String sql = "SELECT strcat('Hello', ', ', 'SQLite!') LIMIT 1";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            stmt.close();

            // drop function
            conn.dropFunction(strcat);

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new ScalarFunctionExample().example();
    }
}
