/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.callback;

/**
 * SQLite Callback function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/busy_handler.html">Register A Callback To Handle SQLITE_BUSY Errors</a>
 * @see <a href="http://sqlite.org/c3ref/commit_hook.html">Commit And Rollback Notification Callbacks</a>
 * @see <a href="http://sqlite.org/c3ref/collation_needed.html">Collation Needed Callbacks</a>
 * @see <a href="http://sqlite.org/c3ref/create_collation.html">Define New Collating Sequences</a>
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 * @see <a href="http://sqlite.org/c3ref/progress_handler.html">Query Progress Callbacks</a>
 * @see <a href="http://sqlite.org/c3ref/set_authorizer.html">Compile-Time Authorization Callbacks</a>
 * @see <a href="http://sqlite.org/c3ref/update_hook.html">Data Change Notification Callbacks</a>
 */
public abstract class Callback {

    /** pointer of myself */
    private volatile long _this = 0;

    public boolean isRegistered() {
        return (_this != 0);
    }
}
