package org.sqlite.event;

import org.sqlite.callback.Callback;

/**
 * Query Progress Callbacks class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/progress_handler.html">Query Progress Callbacks</a>
 */
public abstract class ProgressHandler extends Callback {

    private final int opecodes;
    
    /**
     * default constructor.
     * @param opecodes the number of opcodes for progress callback
     */
    public ProgressHandler(int opecodes) {
        if (opecodes < 1) {
            throw new IllegalArgumentException("Should opecodes is greater than or equal to 1.");
        }
        this.opecodes = opecodes;
    }
    
    /**
     * 
     * @return the number of opcodes for progress callback
     */
    public int getOpCodes() {
        return opecodes;
    }
    
    /**
     * Called from the sqlite3_exec(), sqlite3_step(), sqlite3_get_table() function.
     * @return 0 if the operation is continued. non-zero if the operation is interrupted.
     */
    protected abstract int xProgress();
}
