package org.sqlite.types;

import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;

/**
 * sqlite3_stmt** wrapper class.
 * @author calico
 */
public class SQLite3StmtPtrPtr extends SWIGTYPE_p_p_sqlite3_stmt {
    private boolean isDeleted = false;
    
    /**
     * default constructor.
     * @see org.sqlite.swig.SQLite3#new_p_p_sqlite3_stmt()
     */
    public SQLite3StmtPtrPtr() {
        super(getCPtr(SQLite3.new_p_p_sqlite3_stmt()), false);
    }
    
    /**
     * Delete this object.
     * @see org.sqlite.swig.SQLite3#delete_p_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt)
     */
    public synchronized void delete() {
        if (!isDeleted) {
            SQLite3.delete_p_p_sqlite3_stmt(this);
            isDeleted = true;
        }
    }
    
    /**
     * Returns the sqlite3_stmt* value.
     * @return the sqlite3_stmt* value.
     * @see org.sqlite.swig.SQLite3#get_p_sqlite3_stmt(SWIGTYPE_p_p_sqlite3_stmt)
     */
    public SWIGTYPE_p_sqlite3_stmt getSQLite3StmtPtr() {
        if (isDeleted) {
            throw new IllegalStateException("SQLite3StmtPtrPtr is already deleted.");
        }
        return SQLite3.get_p_sqlite3_stmt(this);
    }

    /**
     * invoke delete() method.
     * @throws java.lang.Throwable
     * @see #delete()
     */
    @Override
    protected void finalize() throws Throwable {
        delete();
        super.finalize();
    }
    
    
}
