package org.sqlite.callback;

import java.io.IOException;
import java.sql.SQLException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3Constants;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class ExecCallbackTest {

    public ExecCallbackTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    @Test(expected = java.sql.SQLException.class)
    public void xCallback() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        SWIGTYPE_p_p_char errmsg = null;
        final ExecCallback callback
                = new ExecCallback() {
                        @Override
                        protected int xCallback(String[] values, String[] columnNames) {
                            assertTrue(isRegistered());
                            assertEquals(5, values.length);
                            assertEquals(values.length, columnNames.length);
                            final int last = values.length;
                            for (int i = 0; i < last; ++i) {
                                System.out.println(columnNames[i] + " :[" + values[i] + "]");
                            }
                            // abort operation
                            return 1;
                        }
                    };
        assertFalse(callback.isRegistered());
        try {
            errmsg = SQLite3.new_p_p_char();
//            String sql= "SELECT * FROM sqlite_temp_master";
            String sql= "SELECT * FROM sqlite_master";
            db.execute(sql, callback, errmsg);
            
        } catch (SQLException ex) {
            assertEquals(SQLite3Constants.SQLITE_ABORT, ex.getErrorCode());
            throw ex;
            
        } finally {
            if (errmsg != null) {
                System.out.println("errmsg is '" + SQLite3.get_p_char(errmsg) + "'");
                SQLite3.delete_p_p_char(errmsg);
            }
            assertFalse(callback.isRegistered());
            db.close();
        }
        
    }

}