/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.event;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class RollbackHookTest {

    public RollbackHookTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }
    
    @Test
    public void setRollbackHook() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        final RollbackHook hook
                = new RollbackHook() {
                        @Override
                        protected void xRollback() {
                            System.out.println("Called xRollback()");
                        }
                    };
        assertFalse(hook.isRegistered());
        try {
            db.setRollbackHook(hook);
            assertTrue(hook.isRegistered());
            
            final Connection conn = newConnection(db);
            conn.setAutoCommit(false);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_rollback_hook_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO tbl_rollback_hook_test(VALUE) VALUES('TEST')";
            assertEquals(1, stmt.executeUpdate(sql));
            stmt.close();
            
            conn.rollback();
            conn.close();
            
        } finally {
            db.close();
            assertFalse(hook.isRegistered());
        }
    }
    
    @Test
    public void clearRollbackHook() throws ClassNotFoundException, SQLException, IOException {
        final Database db = newDatabase();
        final RollbackHook hook
                = new RollbackHook() {
                        @Override
                        protected void xRollback() {
                            System.out.println("Called xRollback1()");
                        }
                    };
        assertFalse(hook.isRegistered());
        try {
            db.setRollbackHook(hook);
            assertTrue(hook.isRegistered());
            
            final Connection conn = newConnection(db);
            conn.setAutoCommit(false);
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS tbl_rollback_hook_test("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO tbl_rollback_hook_test(VALUE) VALUES('TEST')";
            assertEquals(1, stmt.executeUpdate(sql));
            stmt.close();

            final RollbackHook hook2
                    = new RollbackHook() {
                            @Override
                            protected void xRollback() {
                                System.out.println("Called xRollback2()");
                            }
                        };
            assertFalse(hook2.isRegistered());
            db.setRollbackHook(hook2);
            assertTrue(hook2.isRegistered());
            assertFalse(hook.isRegistered());
            
            conn.rollback();
            conn.close();
            
        } finally {
            db.close();
            assertFalse(hook.isRegistered());
        }
    }

}