package my.codeiq.refactor.n;

import my.codeiq.refactor.n.shape.DiamondShape;
import my.codeiq.refactor.n.shape.RoundShape;
import my.codeiq.refactor.n.shape.Shape;
import my.codeiq.refactor.n.shape.animate.HorizontalAnimate;
import my.codeiq.refactor.n.shape.animate.VerticalAnimate;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.JPanel;


public class PictureView extends JPanel {
    private static final long serialVersionUID = 1L;

    /** 画面の一辺の長さ */
    public static final int SIZE = 600;

    /** 生成された図形の配列 */
    private List<Shape> shapes = new ArrayList<Shape>();

    /**
     * PictureView オブジェクトを作る
     */
    public PictureView() {
        shapes.add(new RoundShape(100, 100, 0, 20, Color.YELLOW, new HorizontalAnimate()));
        shapes.add(new DiamondShape(-100, -150, 0, 20, Color.BLUE, new VerticalAnimate()));
        shapes.add(new DiamondShape(30, 0, 400, 40, Color.RED));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        draw(g);
    }

    /**
     * 全ての図形を移動する
     */
    public void animate() {
        for (Shape shape : shapes) {
            shape.animate();
        }
    }

    /**
     * 全ての図形を現在位置に合わせて画面上に描画する
     * 
     * @param g
     *            グラフィック・コンテキスト
     */
    public void draw(Graphics g) {
        // Z軸の順番によるソート(大きい順)
        Collections.sort(shapes, new Comparator<Shape>() {
            public int compare(Shape o1, Shape o2) {
                return (int)(o2.z - o1.z);
            }
        });
        

        // 登録されている全てのオブジェクトを描画する
        for (Shape shape : shapes) {
            // 一点透視図法による描画
            final double CENTER = SIZE / 2.0;
            double d = CENTER / (shape.z + CENTER);
            double r = shape.r * d;
            double x = shape.x * d - r + CENTER;
            double y = shape.y * d - r + CENTER;

            shape.draw(g, x, y, r);
        }
    }
}
