package my.codeiq.refactor.n.shape;

import my.codeiq.refactor.n.shape.animate.Animate;

import java.awt.Color;
import java.awt.Graphics;


public class DiamondShape extends Shape {
    /**
     * コンストラクタ
     */
    public DiamondShape() {
        super();
    }

    /**
     * コンストラクタ
     * 
     * @param x
     *            X 座標
     * @param y
     *            Y 座標
     * @param z
     *            Z 座標
     * @param radius
     *            半径 (大きさ)
     * @param color
     *            色
     */
    public DiamondShape(double x, double y, double z, double radius, Color color) {
        super(x, y, z, radius, color);
    }

    /**
     * コンストラクタ
     * 
     * @param x
     *            X 座標
     * @param y
     *            Y 座標
     * @param z
     *            Z 座標
     * @param radius
     *            半径 (大きさ)
     * @param color
     *            色
     * @param animate
     *            移動
     */
    public DiamondShape(double x, double y, double z, double radius, Color color, Animate animate) {
        super(x, y, z, radius, color, animate);
    }

    /**
     * 現在位置に合わせて画面上に描画する
     * 
     * @param g
     *            グラフィック・コンテキスト
     */
    @Override
    public void draw(Graphics g, double x, double y, double r) {
        g.setColor(color);
        g.fillRect((int) x, (int) y, (int) r * 2, (int) r * 2);
    }

}
