package my.codeiq.refactor.n;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;

public class PictureControl {
    private static final int WIDTH = PictureView.SIZE;
    private static final int HEIGHT = PictureView.SIZE;

    private PictureView view;

    public static void main(String[] args) {
        PictureView v = new PictureView();
        PictureControl pc = new PictureControl(v);
        pc.runScenario();
    }

    public PictureControl(PictureView v) {
        JFrame app = new JFrame("Computer Science");
        app.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        view = v;
        app.setSize(WIDTH, HEIGHT);
        app.setResizable(false);
        app.getContentPane().add(view);
        app.setVisible(true);
    }

    /**
     * PictureView の draw メソッドを呼んで画面を描き直した後、
     * 100 ミリ秒一時停止する。
     */
    public void pause() {
        view.repaint();
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {
        }
    }

    /**
     * 絵の動きのシナリオ
     */
    public void runScenario() {
        while (true) {
            view.animate();
            pause();
        }
    }
}
