#pragma once

#include <string>
#include <vector>
#include <Poco/ActiveMethod.h>
#include <Poco/format.h>
#include <Poco/Logger.h>
#include <Poco/HashMap.h>

#include "Renderer.h"
#include "MediaItem.h"

using std::string;
using std::vector;
using std::wstring;
using Poco::HashMap;
using Poco::ActiveMethod;


/**
 * RegNX.
 * <Scene>̒ŕ`悳ۂ̍ŏPʂłB
 * ėpIȃR|[lgƂėp̂<Content>ɂׂł
 */
class Content
{
private:
	//static const string NULL_STRING;

protected:
	Poco::Logger& _log;
	Renderer& _renderer;

	int _splitType;
//	MediaItemPtr _media;
	string _mediaID;
	bool _playing;

	int _duration;
	int _current;

	int _keycode;
	bool _shift;
	bool _ctrl;

	HashMap<string, string> _properties;
	float _x, _y, _w, _h;

public:
	/** RXgN^ */
	Content(Renderer& renderer, int splitType, float x = 0, float y = 0, float w = 0, float h = 0);

	/** fXgN^ */
	virtual ~Content();

	/**  */
	virtual void initialize();

	/** t@CI[v܂ */
	virtual bool open(const MediaItemPtr media, const int offset = 0);

	/** t@C̏Ă邩ǂ */
	virtual const string opened() const;

	/** Đ */
	virtual void play();

	/** |[Y */
	virtual void pause();

	/** ~ */
	virtual void stop();

	/** ĐIɂܒ~邩ǂ */
	virtual bool useFastStop();

	/**  */
	virtual void rewind();

	/** Đǂ */
	virtual const bool playing() const;

	/** Iǂ */
	virtual const bool finished();

	/** N[Y܂ */
	virtual void close();

	ActiveMethod<void, void, Content> activeClose;

	/**
	 * L[ʒm
	 * @param	keycide	L[R[h
	 * @param	shift	SHIFTL[̉tO
	 * @param	ctrl	CTRLL[̉tO
	 */
	void notifyKey(const int keycode, const bool shift, const bool ctrl);

	/** 1t[1x */
	virtual void process(const DWORD& frame);

	/** ` */
	virtual void draw(const DWORD& frame);

	/** vr[` */
	virtual void preview(const DWORD& frame);

	/** ݂̃t[ */
	virtual const int current() const;

	/** (t[) */
	virtual const int duration() const;

	/** ʒuݒ */
	virtual void setPosition(float x, float y);

	/** ʒu擾 */
	virtual void getPosition(float& x, float& y);

	/** ̈ݒ */
	virtual void setBounds(float w, float h);

	/** wʒü͈͓ǂ */
	virtual const bool contains(float x, float y) const;

	/** p[^ݒ肵܂ */
	void set(const string& key, const string& value);

	/** p[^ݒ肵܂ */
	void set(const string& key, const float& value);

	/** p[^ݒ肵܂ */
	void set(const string& key, const unsigned int& value);

	/** p[^擾܂ */
	const string& get(const string& key, const string& defaultValue = "") const;

	/** p[^擾܂ */
	const DWORD getDW(const string& key, const DWORD& defaultValue = 0) const;

	/** p[^擾܂ */
	const int getI(const string& key, const int& defaultValue = 0) const;

	/** p[^擾܂ */
	const float getF(const string& key, const float& defaultValue = 0) const;
};

typedef Content* ContentPtr;
