//
// switch.cpp
// AvP[V̎
//

#include <winsock2.h>
#include <windows.h>
#include <psapi.h>
#include <Dbt.h>

#include <Poco/format.h>
#include <Poco/Logger.h>
#include <Poco/UnicodeConverter.h>
#include <Poco/Net/HTTPServer.h>
#include <Poco/Net/HTTPServerParams.h>
#include <Poco/Net/ServerSocket.h>
#include <Poco/Net/HTTPStreamFactory.h>
#include <Poco/Net/HTTPSStreamFactory.h>
#include <Poco/Net/KeyConsoleHandler.h>
#include <Poco/Net/ConsoleCertificateHandler.h>
#include <Poco/Net/SSLManager.h>
#include <Poco/SharedPtr.h>
#include <Poco/Net/SSLManager.h>

#include "switch.h"
#include "Renderer.h"
#include "CaptureScene.h"
#include "MainScene.h"
#include "DiffDetectScene.h"
#ifdef USE_OPENNI
#include "OpenNIScene.h"
#endif
//#include "UserInterfaceScene.h"
#include "Utils.h"
#include "WebAPI.h"
//#include "ui/UserInterfaceManager.h"

//#ifndef _DEBUG
//#include <omp.h>
//#endif

#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>                // ŌɃCN[hقCBC++̏ꍇBWwb_̒newƂƕςɂȂHH
#ifdef _DEBUG
#define new ::new(_NORMAL_BLOCK,__FILE__,__LINE__)     // ꂪdv
#endif


static TCHAR clsName[] = TEXT("switchClass"); // NX

static Configuration _conf;

static RendererPtr _renderer;
//static ui::UserInterfaceManagerPtr _uim;

//static string _interruptFile;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
#if defined(DEBUG) | defined(_DEBUG)
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
//	_CrtSetBreakAlloc(4141);
//	_CrtSetBreakAlloc(3627);
//	_CrtSetBreakAlloc(7048);
#endif
#if defined(DEBUG) | defined(_DEBUG)
#endif
#ifdef _DEBUG
//_CrtDumpMemoryLeaks();
#endif

	_conf.initialize();
	Poco::Logger& log = Poco::Logger::get("");
#ifdef _DEBUG
	log.information("*** system start (debug)");
#else 
	//#pragma omp parallel
	//{
	//	log.information(Poco::format("*** system start (omp threads x%d)", omp_get_num_threads()));
	//}
#endif
	vector<string> args;
	svvitch::split(lpCmdLine, ' ', args);
	for (vector<string>::iterator it = args.begin(); it != args.end(); it++) {
		string opt = Poco::toLower(*it);
		if (opt == "-w") {
			it++;
			if (it != args.end()) {
				long t = Poco::NumberParser::parse(*it);
				log.information(Poco::format("startup waiting: %lds", t));
				Poco::Thread::sleep(t * 1000);
			}
		}
	}

	HWND hWnd;
	MSG msg;
	// EBhENX̏
	WNDCLASSEX wcex = {
		sizeof(WNDCLASSEX),				// ̍\̂̃TCY
		CS_DBLCLKS,						// EChẼX^C(default)
		WindowProc,						// bZ[W֐̓o^
		0,								// ʏ͎gȂ̂ŏ0
		0,								// ʏ͎gȂ̂ŏ0
		hInstance,						// CX^Xւ̃nh
		NULL,							// ACRiȂj
		LoadCursor(NULL, IDC_ARROW),	// J[\̌`
		NULL, NULL,						// wiȂAj[Ȃ
		clsName,						// NX̎w
		NULL							// ACRiȂj
	};

	// EBhENX̓o^
	if (RegisterClassEx(&wcex) == 0) {
		MessageBox(0, L"EBhENX̓o^Ɏs܂", NULL, MB_OK);
		return 0;	// o^s
	}

	// EBhE̍쐬
	std::wstring wtitle;
	Poco::UnicodeConverter::toUTF16(_conf.windowTitle, wtitle);
	if (_conf.fullsceen) {
		// tXN[
		// ʑŜ̕ƍ擾
		int sw = GetSystemMetrics(SM_CXSCREEN);
		int sh = GetSystemMetrics(SM_CYSCREEN);

		hWnd = CreateWindow(
					wcex.lpszClassName,			// o^ĂNX
					wtitle.c_str(), 			// EChE
					WS_POPUP,					// EChEX^Ci|bvAbvEChE쐬j
					0, 							// EChẺ̈ʒu
					0, 							// EChȄc̈ʒu
					_conf.mainRect.right,		// EChE̕
					_conf.mainRect.bottom,		// EChE̍
					NULL,						// eEChẼnhiȗj
					NULL,						// j[qEChẼnh
					hInstance, 					// AvP[VCX^X̃nh
					NULL						// EChE̍쐬f[^
				);

	} else {
		// EBhE[h
		DWORD dwStyle;
		if (_conf.frame) {
			dwStyle = WS_OVERLAPPEDWINDOW;
		} else {
			dwStyle = WS_POPUP;
		}
		hWnd = CreateWindow(clsName,
							wtitle.c_str(),
							dwStyle,
							CW_USEDEFAULT, CW_USEDEFAULT, 
							CW_USEDEFAULT, CW_USEDEFAULT,
							NULL, NULL, hInstance, NULL);

		if (hWnd) {
			// EBhETCYĐݒ肷
			RECT rect;
			int ww, wh;
			int cw, ch;

			// EChEŜ̉̕vZ
			GetWindowRect(hWnd, &rect);		// EChEŜ̃TCY擾
			ww = rect.right - rect.left;	// EChEŜ̉̕vZ
			wh = rect.bottom - rect.top;	// EChEŜ̏̕cvZ
			
			// NCAg̈̊O̕vZ
			GetClientRect(hWnd, &rect);		// NCAg̃TCY̎擾
			cw = rect.right - rect.left;	// NCAg̈ỎvZ
			ch = rect.bottom - rect.top;	// NCAg̈ȌcvZ

			ww = ww - cw;					// NCAg̈ȊOɕKvȕ
			wh = wh - ch;					// NCAg̈ȊOɕKvȍ

			// EBhETCY̍ČvZ
			ww = _conf.mainRect.right + ww;	// KvȃEChE̕
			wh = _conf.mainRect.bottom + wh;	// KvȃEChE̍

			// EChETCY̍Đݒ
			SetWindowPos(hWnd, HWND_TOP, _conf.mainRect.left, _conf.mainRect.top, ww, wh, 0);

			// hbNhbv̎t
			DragAcceptFiles(hWnd, TRUE);
		}
	}
	if (!hWnd) {
		MessageBox(0, L"EBhE̐Ɏs܂", NULL, MB_OK);
		return 0;
	}

	// EBhE̕\
	UpdateWindow(hWnd);
    ShowWindow(hWnd, nCmdShow);

	// WM_PAINTĂ΂Ȃ悤ɂ
	ValidateRect(hWnd, 0);

	// _[̏
	_renderer = new Renderer();	
	HRESULT hr = _renderer->initialize(hInstance, hWnd);
	if (FAILED(hr)) {
		MessageBox(0, L"_[̏Ɏs܂", NULL, MB_OK);
		return 0;	// s
	}

	Poco::Net::HTTPStreamFactory::registerFactory();
	Poco::Net::HTTPSStreamFactory::registerFactory();
	Poco::SharedPtr<Poco::Net::PrivateKeyPassphraseHandler> console = new Poco::Net::KeyConsoleHandler(false);
	Poco::SharedPtr<Poco::Net::InvalidCertificateHandler> cert = new Poco::Net::ConsoleCertificateHandler(false);
	Poco::Net::Context::Ptr context = new Poco::Net::Context(Poco::Net::Context::CLIENT_USE, "", Poco::Net::Context::VERIFY_NONE);
	Poco::Net::SSLManager::instance().initializeClient(console, cert, context);
	// init of server part is not required, but we keep the code here as an example
	/*
	ptrConsole = new KeyConsoleHandler(true);    // ask the user via console for the pwd
	ptrCert = new ConsoleCertificateHandler(true); // ask the user via console
	ptrContext = new Context("any.pem", "rootcert.pem", true, Context::VERIFY_NONE, 9, false, "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH");
	SSLManager::instance().initializeServer(ptrConsole, ptrCert, ptrContext);
	*/

	//_uim = new ui::UserInterfaceManager(*_renderer);
	//_uim->initialize();
	// V[̐
	CaptureScenePtr captureScene = NULL;
	if (_conf.hasScene("capture")) {
		captureScene = new CaptureScene(*_renderer);
		captureScene->initialize();
		_renderer->addScene("capture", captureScene);
	}
#ifdef USE_OPENNI
	OpenNIScenePtr openNIScene = NULL;
	if (_conf.hasScene("openni")) {
		openNIScene = new OpenNIScene(*_renderer);
		openNIScene->initialize();
		_renderer->addScene("openni", openNIScene);
	}
#endif
	MainScenePtr mainScene = NULL;
	if (true) {
		mainScene = new MainScene(*_renderer);
		_renderer->addScene("main", mainScene);
	}
	//if (_conf.hasScene("diff")) {
	//	DiffDetectScenePtr diffScene = new DiffDetectScene(*_renderer);
	//	diffScene->initialize();
	//	_renderer->addScene("diff", diffScene);
	//}
	// UserInterfaceScenePtr uiScene = new UserInterfaceScene(*_renderer, _uim);
	// _renderer->addScene("ui", uiScene);

	Poco::Net::HTTPServerParams* params = new Poco::Net::HTTPServerParams;
	params->setMaxQueued(_conf.maxQueued);
	params->setMaxThreads(_conf.maxThreads);
	Poco::Net::ServerSocket socket(_conf.serverPort);
	Poco::Net::HTTPServer* server = new Poco::Net::HTTPServer(new SwitchRequestHandlerFactory(*_renderer), socket, params);
	server->start();

	// bZ[Wѕ`惋[v
	//EmptyWorkingSet(GetCurrentProcess());
	//::SetThreadAffinityMask(::GetCurrentThread(), 1);
	mainloop(hWnd);

	log.information(Poco::format("shutdown web api server: %dthreads", server->currentThreads()));
	server->stop();
	int t = 10;
	while (t-- > 0) {
		_renderer->peekMessage();
		Poco::Thread::sleep(50);
	}
	SAFE_DELETE(server);
	Poco::Net::SSLManager::instance().shutdown();

	int exitCode = _renderer->getExitCode();
	log.information(Poco::format("shutdown system (%d)", exitCode));
	SAFE_DELETE(_renderer);
	//SAFE_DELETE(_uim);
	_conf.save();
	_conf.release();
	CoUninitialize();

	UnregisterClass(clsName, wcex.hInstance);
	return exitCode;
}

void mainloop(HWND hWnd) {
	SetThreadAffinityMask(::GetCurrentThread(), 1 | 2 | 4 | 8);
	EXCEPTION_RECORD ERecord;
	CONTEXT EContext; 
	__try {
		SetErrorMode(SEM_NOGPFAULTERRORBOX);

		LARGE_INTEGER freq;
		LARGE_INTEGER start;
		LARGE_INTEGER current;
		::QueryPerformanceFrequency(&freq);
		::QueryPerformanceCounter(&start);
		LONGLONG last = 0;

		//	DWORD lastSwapout = 0;
		while (_renderer->peekMessage()) {
			// 郁bZ[WƂ͕`s
			//if (_interruptFile.length() > 0) {
			//	scene->prepareInterruptFile(_interruptFile);
			//	_interruptFile.clear();
			//}

			::QueryPerformanceCounter(&current);
			LONGLONG time = (current.QuadPart - start.QuadPart) * 1000 / freq.QuadPart;
			last = time;

			// EBhEĂ鎞`悷邽߂̏
			WINDOWPLACEMENT wndpl;
			GetWindowPlacement(hWnd, &wndpl);	// EChȄԂ擾
			bool visibled = (wndpl.showCmd != SW_HIDE) && (wndpl.showCmd != SW_MINIMIZE) && (wndpl.showCmd != SW_SHOWMINIMIZED) && (wndpl.showCmd != SW_SHOWMINNOACTIVE);
			_renderer->renderScene(visibled, time);
			Poco::Thread::sleep(_conf.frameIntervals);
		}
	} __except(ERecord = *(GetExceptionInformation())->ExceptionRecord,
		EContext = *(GetExceptionInformation())->ContextRecord, EXCEPTION_EXECUTE_HANDLER) {

		FILE* fp;
		time_t gmt;
		time(&gmt);
		struct tm* localTime = localtime(&gmt);
		fp = fopen("exception_rec.txt", "a");
		if (fp != NULL) {
			fprintf(fp, "----------------------\n");
			//fprintf(fp, "Oo܂\n");
			fprintf(fp, "OF%.19s\n", asctime(localTime));
			fprintf(fp, "OR[hF%X\n", ERecord.ExceptionCode);
			fprintf(fp, "OtOF%d\n", ERecord.ExceptionFlags);
			fprintf(fp, "OAhXF%X\n", ERecord.ExceptionAddress);
			fclose(fp);
		}
	}
}

LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg) {
		case WM_CREATE:
			::ShowCursor(config().mouse);
			break;

		case WM_CLOSE:					// EChEꂽ
			::ShowCursor(TRUE);
			PostQuitMessage(0);			// AvP[VI
			break;

		case WM_SETFOCUS:
			break;
		case WM_KILLFOCUS:
			break;

		case WM_IME_SETCONTEXT:
			lParam &= ~ISC_SHOWUIALL;
			break;
		case WM_IME_STARTCOMPOSITION:
		case WM_IME_COMPOSITION:
		case WM_IME_ENDCOMPOSITION:
			return 0;
		case WM_IME_NOTIFY:
			switch(wParam){
			case IMN_OPENSTATUSWINDOW:
			case IMN_CLOSESTATUSWINDOW:
			case IMN_OPENCANDIDATE:
			case IMN_CHANGECANDIDATE:
			case IMN_CLOSECANDIDATE:
				return 0;
			default:
				return DefWindowProc(hWnd, msg, wParam, lParam);
			}


		case WM_KEYDOWN:
			if (wParam == VK_ESCAPE) {
				PostQuitMessage(0);
			} else {
				bool shift = GetKeyState(VK_SHIFT) < 0;
				bool ctrl = GetKeyState(VK_CONTROL) < 0;
				if (_renderer) _renderer->notifyKeyDown(wParam, shift, ctrl);
			}
			break;
		case WM_KEYUP:
			{
				bool shift = GetKeyState(VK_SHIFT) < 0;
				bool ctrl = GetKeyState(VK_CONTROL) < 0;
				if (ctrl && wParam == 'S') {
					swapout();
				} else {
					if (_renderer) _renderer->notifyKeyUp(wParam, shift, ctrl);
				}
			}
			break;

		case WM_MOUSEMOVE:
			//if (_uim) _uim->notifyMouseMove(LOWORD(lParam), HIWORD(lParam));
			break;
		case WM_MOUSEWHEEL:
			//if (_uim) _uim->notifyMouseWheel((SHORT)HIWORD(wParam));
			break;
		case WM_LBUTTONDOWN:
			//if (_uim) _uim->notifyButtonDownL(LOWORD(lParam), HIWORD(lParam));
			::SetCapture(hWnd);
			break;
		case WM_LBUTTONUP:
			//if (_uim) _uim->notifyButtonUpL(LOWORD(lParam), HIWORD(lParam));
			::ReleaseCapture();
			break;
		case WM_RBUTTONDOWN:
			//_uim->notifyButtonDownR(LOWORD(lParam), HIWORD(lParam));
			::SetCapture(hWnd);
			break;
		case WM_RBUTTONUP:
			//if (_uim) _uim->notifyButtonUpR(LOWORD(lParam), HIWORD(lParam));
			::ReleaseCapture();
			break;

		case WM_DROPFILES:
			{
				HDROP hDrop = (HDROP)wParam; /* HDROP擾 */
				vector<WCHAR> dropFile(255);
				DragQueryFile(hDrop, 0, &dropFile[0], 256); /* ŏ̃t@C擾 */
				DragFinish(hDrop); /* hbv̏I */
				//Poco::UnicodeConverter::toUTF8(&dropFile[0], _interruptFile);
			}
			break;

		case WM_DEVICECHANGE:
			{
				switch (wParam) {
				case DBT_DEVICEARRIVAL:
					{
						DEV_BROADCAST_HDR* data = (DEV_BROADCAST_HDR*)lParam;
						if (data && data->dbch_devicetype == DBT_DEVTYP_VOLUME) {
							DEV_BROADCAST_VOLUME* extend = (DEV_BROADCAST_VOLUME*)data;
							if (extend && _renderer) _renderer->addDrive(extend->dbcv_unitmask);
						}
					}
					break;
				case DBT_DEVICEREMOVECOMPLETE:
					{
						DEV_BROADCAST_HDR* data = (DEV_BROADCAST_HDR*)lParam;
						if (data && data->dbch_devicetype == DBT_DEVTYP_VOLUME) {
							DEV_BROADCAST_VOLUME* extend = (DEV_BROADCAST_VOLUME*)data;
							if (extend && _renderer) _renderer->removeDrive(extend->dbcv_unitmask);
						}
					}
					break;
				case DBT_DEVNODES_CHANGED:
					break;
				}
				_renderer->deviceChanged();
			}
			break;

		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
    }
    return 0;
}


Configuration& config() {
	return _conf;
}

void swapout() {
	Poco::Logger& log = Poco::Logger::get("");
	log.information("*** exec memory swapout");
	EmptyWorkingSet(GetCurrentProcess());
	return;

	DWORD idProcess[1024];
	DWORD bsize = 0;
	/* vZXʎq擾 */
	if (EnumProcesses(idProcess, sizeof(idProcess), &bsize) == FALSE) {
		log.warning("failed EnumProcesses()");
		return;
	}
	log.information("*** exec memory swapout");
	int proc_num = bsize / sizeof(DWORD);
	WCHAR name[1024];
	for (int i = 0; i < proc_num; i++) {
		/* vZXnh擾 */
		HANDLE	handle = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_SET_QUOTA | PROCESS_VM_READ, FALSE, idProcess[i]);
		if (handle != NULL) {
			bool swapouted = false;
			if (handle != GetCurrentProcess()) {
				// ȊÕvZXXbvAEg
				swapouted = EmptyWorkingSet(handle)==TRUE;
			}
			HMODULE	module[1024];
			if (EnumProcessModules(handle, module, sizeof(module), &bsize) != FALSE ) {
				/* vZX擾 */
				if (GetModuleBaseName(handle, module[0], name, sizeof(name)) > 0) {
					PROCESS_MEMORY_COUNTERS pmc = {0};
					GetProcessMemoryInfo(handle, &pmc, sizeof(PROCESS_MEMORY_COUNTERS));
					int mem = pmc.WorkingSetSize / 1024;
					string swapout = swapouted?"<swapouted>":"";
					string nameUTF8;
					Poco::UnicodeConverter::toUTF8(wstring(name), nameUTF8);
					log.information(Poco::format("process: %20s %05dkB%s", nameUTF8, mem, swapout));
				}
			}
			CloseHandle(handle);
		}
	}
}
