#pragma once

#include "Content.h"
#include "Renderer.h"
#include <Poco/ActiveMethod.h>
#include <Poco/Mutex.h>
#include <mfapi.h>
#include <mfidl.h>

#pragma comment(lib, "mf.lib")


/**
 * MediaFoundationĐRegNX.
 */
class MFContent: public Content {
private:
	Poco::FastMutex _lock;
	bool _finished;
	IMFMediaSession* _session;

public:
	MFContent(Renderer& renderer, int splitType);

	virtual ~MFContent();


	void initialize();

	/** t@CI[v܂ */
	bool open(const MediaItemPtr media, const int offset = 0);

	/**
	 * Đ
	 */
	void play();

	/**
	 * ~
	 */
	void stop();

	/**
	 * Đǂ
	 */
	const bool playing() const;

	const bool finished();

	/** t@CN[Y܂ */
	void close();

	void process(const DWORD& frame);

	void draw(const DWORD& frame);
};

typedef MFContent* MFContentPtr;
