using System;
using System.IO;

using SystemNeo.IO;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class ViewingConditions
	{
		#region private fields
		private readonly Fraction[] illuminant;
		private readonly Fraction[] surround;
		private readonly IlluminantType illuminantType;
		#endregion

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal ViewingConditions(BinaryReaderNeo reader)
		{
			this.illuminant = IccUtil.ReadFractions(reader, 3);
			this.surround = IccUtil.ReadFractions(reader, 3);
			this.illuminantType = (IlluminantType)reader.ReadUInt32();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Illuminant=");
			IccUtil.fractionArrayFormatter.WriteTo(sw, this.illuminant);
			sw.Write(", Surround=");
			IccUtil.fractionArrayFormatter.WriteTo(sw, this.surround);
			sw.Write(", IlluminantType=");
			sw.Write(this.illuminantType);
			sw.Write("}");
			return sw.ToString();
		}
	}
}
