using System;
using System.IO;

using SystemNeo;
using SystemNeo.Drawing.Imaging.Tiff;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class App1SegmentContent : SegmentContent
	{
		/// <summary>
		/// 
		/// </summary>
		public const string ExifId = "Exif\0\0";

		/// <summary>
		/// 
		/// </summary>
		public const string XmpNamespace = "http://ns.adobe.com/xap/1.0/";

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Id { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public TiffData Tiff { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public string Xmp { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal App1SegmentContent(BinaryReaderNeo reader)
		{
			this.Id = reader.ReadString(ExifId.Length);
			if (this.Id == ExifId) {
				var tiffStream = new PartialStream(reader.BaseStream);
				this.Tiff = TiffData.FromStream(tiffStream);
			} else {
				string s = reader.PeekString('\0');
				if (this.Id + s == XmpNamespace + '\0') {
					// XMPǂݎ
					this.Id += s;
					reader.Seek(s.Length);
					this.Xmp = reader.ReadToEndAsString();
				} else {
					string msg = string.Format("APP1IDsłBID={0} Length={1:N0}",
							new QuotedStringFormatter().ToString(this.Id), reader.Length);
					throw new BadImageFormatException(msg);
				}
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Id=");
			sw.Write(this.Id.TrimEnd('\0'));
			sw.Write(", ");
			if (this.Xmp == null) {
				sw.Write("Tiff=");
				sw.Write(this.Tiff);
			} else {
				int max = 1024;
				string xmp = StringUtil.RemoveEmptyLine(this.Xmp);
				sw.Write("Xmp={");
				sw.Write(xmp.Length <= max ? xmp : xmp.Substring(0, max) + "...");
				sw.Write("}");
			}
			return sw.ToString();
		}
	}
}
