using System;
using System.Drawing;
using System.IO;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class Sof0SegmentContent : SegmentContent
	{
		#region private fields
		private readonly ushort rows;
		private readonly ushort cols;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public Component[] Components { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Size ImageSize
		{
			get {
				return new Size(this.cols, this.rows);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public int SamplePrecision { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name='reader'></param>
		internal Sof0SegmentContent(BinaryReaderNeo reader)
		{
			this.SamplePrecision = reader.ReadByte();
			this.rows = reader.ReadUInt16();
			this.cols = reader.ReadUInt16();
			int count = reader.ReadByte();
			this.Components = new Component[count];
			for (int i = 0; i < count; i++) {
				var id = (YCbCrComponent)reader.ReadByte();
				this.Components[i] = new Component(id, reader.ReadByte(), reader.ReadByte());
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("SamplePrecision=");
			sw.Write(this.SamplePrecision);
			sw.Write(", ImageSize=");
			sw.Write(this.cols);
			sw.Write("x");
			sw.Write(this.rows);
			sw.Write(", Components=");
			new CollectionFormatter().WriteTo(sw, this.Components);
			return sw.ToString();
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public struct Component
		{
			#region private fields
			private readonly YCbCrComponent componentId;
			private readonly byte xSamplingFactor;
			private readonly byte ySamplingFactor;
			private readonly byte quantizationTableId;
			#endregion

			// public vpeB //

			/// <summary>
			/// 
			/// </summary>
			public YCbCrComponent ComponentId
			{
				get {
					return this.componentId;
				}
			}

			/// <summary>
			/// 
			/// </summary>
			public int QuantizationTableId
			{
				get {
					return this.quantizationTableId;
				}
			}

			/// <summary>
			/// 
			/// </summary>
			public Point SamplingFactor
			{
				get {
					return new Point(this.xSamplingFactor, this.ySamplingFactor);
				}
			}

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name='componentId'></param>
			/// <param name='samplingFactor'></param>
			/// <param name='quantizationTableId'></param>
			internal Component(
					YCbCrComponent componentId, byte samplingFactor, byte quantizationTableId)
			{
				this.componentId = componentId;
				ObjectUtil.SplitBits(
						samplingFactor, out this.xSamplingFactor, out this.ySamplingFactor);
				this.quantizationTableId = quantizationTableId;
			}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override string ToString()
			{
				var sw = new StringWriter();
				sw.Write("{");
				sw.Write(this.componentId);
				sw.Write(", ");
				sw.Write(this.xSamplingFactor);
				sw.Write(":");
				sw.Write(this.ySamplingFactor);
				sw.Write(", ");
				sw.Write(this.quantizationTableId);
				sw.Write("}");
				return sw.ToString();
			}
		}
	}
}
