using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	internal struct APPBARDATA
	{
		#region private & internal fields
		private readonly int cbSize;
		private readonly IntPtr hWnd;
		private readonly int uCallbackMessage;
		private readonly AppBarEdge uEdge;
		internal RECT rc;
		private readonly IntPtr lParam;
		#endregion

		// internal vpeB //

		/// <summary>
		/// 
		/// </summary>
		internal AppBarEdge Edge
		{
			get {
				return this.uEdge;
			}
		}

		// RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="dockStyle"></param>
		internal APPBARDATA(Control control, DockStyle dockStyle) : this(control, dockStyle, 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="dockStyle"></param>
		/// <param name="callbackMessage"></param>
		internal APPBARDATA(Control control, DockStyle dockStyle, int callbackMessage)
		{
			this.cbSize = Marshal.SizeOf(typeof(APPBARDATA));
			this.hWnd = control.Handle;
			this.uCallbackMessage = callbackMessage;
			this.uEdge = NativeMethods.ToAppBarEdge(dockStyle);
			this.rc = new RECT();
			this.lParam = IntPtr.Zero;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="control"></param>
		/// <param name="dockStyle"></param>
		/// <param name="rect"></param>
		internal APPBARDATA(Control control, DockStyle dockStyle, Rectangle rect)
				: this(control, dockStyle)
		{
			this.rc = (RECT)rect;
		}
	}
}
