using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using SystemNeo;
using SystemNeo.Windows;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// AppBarForm ́AWindows ̃^XNo[̋@\tH[łB
	/// </summary>
	public class AppBarForm : Form
	{
		#region private static field
		private static int appBarCallbackMessage;
		#endregion

		#region private field
		private DockStyle dockStyle = DockStyle.Top;
		#endregion

		// public vpeB //

		/// <summary>
		/// tH[ʂ̂ǂ̒[ɉ\܂B
		/// </summary>
		[DefaultValue(DockStyle.Top)]
		public DockStyle DockStyle
		{
			get {
				return this.dockStyle;
			}
			set {
				ArgumentUtil.AssertInvalidEnum(value, "DockStyle");
				this.dockStyle = value;
			}
		}

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static AppBarForm()
		{
			string messageName = typeof(AppBarForm).FullName + "::AppBarMessage";
			appBarCallbackMessage = NativeMethods.RegisterWindowMessage(messageName);
		}

		// protected vpeB //

		/// <summary>
		/// 
		/// </summary>
		protected override void CreateHandle()
		{
			base.CreateHandle();
			if (! this.DesignMode) {
				this.RegisterAppBar();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		protected override CreateParams CreateParams
		{
			get {
				CreateParams cp = base.CreateParams;
				cp.ExStyle |= (int)WindowExStyles.WS_EX_TOOLWINDOW;
				return cp;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		protected override void DestroyHandle()
		{
			if (! this.DesignMode) {
				this.UnregisterAppBar();
			}
			base.DestroyHandle();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		protected override void WndProc(ref Message m)
		{
			if (m.Msg == appBarCallbackMessage) {
				switch ((AppBarNotification)m.WParam.ToInt32()) {
				case AppBarNotification.ABN_POSCHANGED:
					this.SetAppBarPosition();
					break;
				}
			}
			base.WndProc(ref m);
		}
		
		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		private void RegisterAppBar()
		{
			var abd = new APPBARDATA(this, DockStyle.Left, appBarCallbackMessage);
			NativeMethods.SHAppBarMessage(AppBarMessage.ABM_NEW, ref abd);
			this.SetAppBarPosition();
		}

		/// <summary>
		/// 
		/// </summary>
		private void SetAppBarPosition()
		{
			var rect = new Rectangle(new Point(), SystemInformation.PrimaryMonitorSize);
			var abd = new APPBARDATA(this, this.dockStyle, rect);

			switch (abd.Edge) {
			case AppBarEdge.ABE_LEFT:
				abd.rc.right = this.Width;
				break;
			case AppBarEdge.ABE_TOP:
				abd.rc.bottom = this.Height;
				break;
			case AppBarEdge.ABE_RIGHT:
				abd.rc.left = abd.rc.right - this.Width;
				break;
			case AppBarEdge.ABE_BOTTOM:
				abd.rc.top = abd.rc.bottom - this.Height;
				break;
			}

			NativeMethods.SHAppBarMessage(AppBarMessage.ABM_QUERYPOS, ref abd);

			switch (abd.Edge) {
			case AppBarEdge.ABE_LEFT:
				abd.rc.right = abd.rc.left + this.Width;
				break;
			case AppBarEdge.ABE_TOP:
				abd.rc.bottom = abd.rc.top + this.Height;
				break;
			case AppBarEdge.ABE_RIGHT:
				abd.rc.left = abd.rc.right - this.Width;
				break;
			case AppBarEdge.ABE_BOTTOM:
				abd.rc.top = abd.rc.bottom - this.Height;
				break;
			}

			NativeMethods.SHAppBarMessage(AppBarMessage.ABM_SETPOS, ref abd);

			FormsUtil.MoveWindow(this, (Rectangle)abd.rc, true);
		}

		/// <summary>
		/// 
		/// </summary>
		private void UnregisterAppBar()
		{
			var abd = new APPBARDATA(this, DockStyle.Left);
			NativeMethods.SHAppBarMessage(AppBarMessage.ABM_REMOVE, ref abd);
		}
	}
}
