using System;
using System.Windows.Forms;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// Xgr[Rg[Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class ListViewUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listView"></param>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public static void InvokeUpdate(
				ListView listView, Delegate @delegate, params object[] @params)
		{
			InvokeUpdate(listView, new DelegateInvocation(@delegate, @params));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listView"></param>
		/// <param name="invocation"></param>
		public static void InvokeUpdate(ListView listView, DelegateInvocation invocation)
		{
			ArgumentUtil.AssertNull(listView, "listView");
			ArgumentUtil.AssertNull(invocation, "invocation");
			listView.Invoke(new Action(() => Update<object>(listView, invocation.Invoke)));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listView"></param>
		/// <param name="count"></param>
		public static void SetItemCount(ListView listView, int count)
		{
			ArgumentUtil.AssertNull(listView, "listView");
			listView.BeginUpdate();
			try {
				int difference = listView.Items.Count - count;
				if (difference > 0) {
					for (int i = difference - 1; i >= 0; i--) {
						listView.Items.RemoveAt(count + i);
					}
				} else if (difference < 0) {
					for (int i = difference; i < 0; i++) {
						listView.Items.Add(string.Empty);
					}
				}
			} finally {
				listView.EndUpdate();
			}
		}

		/// <summary>
		/// ListView ̍ڂבւ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="listView"></param>
		/// <param name="converter"></param>
		public static void Sort<T>(ListView listView, Func<ListViewItem, T> converter)
				where T : IComparable
		{
			ArgumentUtil.AssertNull(converter, "converter");
			SortInternal(listView, DelegateUtil.CreateComparison(converter));
		}

		/// <summary>
		/// ListView ̍ڂבւ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="listView"></param>
		/// <param name="converter"></param>
		/// <param name="comparison"></param>
		public static void Sort<T>(ListView listView,
				Func<ListViewItem, T> converter, Comparison<T> comparison)
		{
			ArgumentUtil.AssertNull(converter, "converter");
			ArgumentUtil.AssertNull(comparison, "comparison");
			SortInternal(listView, DelegateUtil.CreateComparison(comparison, converter));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listView"></param>
		/// <param name="action"></param>
		public static void Update(ListView listView, Action action)
		{
			ArgumentUtil.AssertNull(listView, "listView");
			listView.BeginUpdate();
			try {
				action();
			} finally {
				listView.EndUpdate();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="listView"></param>
		/// <param name="action"></param>
		/// <returns></returns>
		public static T Update<T>(ListView listView, Func<T> action)
		{
			ArgumentUtil.AssertNull(listView, "listView");
			listView.BeginUpdate();
			try {
				return action();
			} finally {
				listView.EndUpdate();
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="listView"></param>
		/// <param name="comparison"></param>
		private static void SortInternal(ListView listView, Comparison<ListViewItem> comparison)
		{
			ArgumentUtil.AssertNull(listView, "listView");
			listView.ListViewItemSorter = new ComparisonComparer<ListViewItem>(comparison);
		}
	}
}
