using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections;
using SystemNeo.Xml;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// c[r[Rg[Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class TreeViewUtil
	{
		// public static \bh //

		/// <summary>
		/// XML ̃m[hc[ TreeNode ܂B
		/// </summary>
		/// <param name="xmlNode"></param>
		/// <param name="node"></param>
		/// <param name="createNode"></param>
		public static void ConvertNodes(
				XmlNode xmlNode, TreeNode node, Func<object, TreeNode> nodeGenerator)
		{
			ConvertNodes(xmlNode, node, nodeGenerator, -1);
		}

		/// <summary>
		/// XML ̃m[hc[ TreeNode ܂B
		/// </summary>
		/// <param name="xmlNode"></param>
		/// <param name="treeView"></param>
		/// <param name="createNode"></param>
		public static void ConvertNodes(
				XmlNode xmlNode, TreeView treeView, Func<object, TreeNode> nodeGenerator)
		{
			ConvertNodes(xmlNode, treeView, nodeGenerator, -1);
		}

		/// <summary>
		/// XML ̃m[hc[ TreeNode ܂B
		/// </summary>
		/// <param name="xmlNode"></param>
		/// <param name="node"></param>
		/// <param name="createNode"></param>
		/// <param name="depth"></param>
		public static void ConvertNodes(
				XmlNode xmlNode, TreeNode node, Func<object, TreeNode> nodeGenerator, int depth)
		{
			ArgumentUtil.AssertNull(xmlNode, "xmlNode");
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(nodeGenerator, "createNode");
			ConvertNodesInternal(xmlNode, node, nodeGenerator, depth);
		}

		/// <summary>
		/// XML ̃m[hc[ TreeNode ܂B
		/// </summary>
		/// <param name="xmlNode"></param>
		/// <param name="treeView"></param>
		/// <param name="createNode"></param>
		/// <param name="depth"></param>
		public static void ConvertNodes(
				XmlNode xmlNode, TreeView treeView, Func<object, TreeNode> nodeGenerator, int depth)
		{
			ArgumentUtil.AssertNull(xmlNode, "xmlNode");
			ArgumentUtil.AssertNull(treeView, "treeView");
			ArgumentUtil.AssertNull(nodeGenerator, "createNode");
			ConvertNodesInternal(xmlNode, treeView, nodeGenerator, depth);
		}

		/// <summary>
		/// TreeView ɂc[m[h̐[擾܂B[gm[h̐[ 0 łB
		/// </summary>
		/// <remarks>
		/// ̃\bh̕ԂĺA.NET Framework version 2.0 ȍ~ł
		/// TreeNode NX Level vpeBƓłB
		/// </remarks>
		/// <param name="node"></param>
		/// <returns></returns>
		public static int GetNodeLevel(TreeNode node)
		{
			ArgumentUtil.AssertNull(node, "node");
			int level = 0;
			for (;;) {
				node = node.Parent;
				if (node == null) {
					break;
				}
				level++;
			}
			return level;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public static void InvokeUpdate(
				TreeView treeView, Delegate @delegate, params object[] @params)
		{
			InvokeUpdate(treeView, new DelegateInvocation(@delegate, @params));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="invocation"></param>
		public static void InvokeUpdate(TreeView treeView, DelegateInvocation invocation)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			ArgumentUtil.AssertNull(invocation, "invocation");
			treeView.Invoke(new Action(() => Update<object>(treeView, invocation.Invoke)));
		}

		/// <summary>
		/// Q̃c[m[hcƎq̊֌Wɂ邩ǂ𒲂ׂ܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="target"></param>
		/// <returns>
		/// <paramref name="node"/>  <paramref name="target"/> ̑cłꍇ trueB
		/// ȊȌꍇ falseB
		/// </returns>
		public static bool IsAncestorOf(TreeNode node, TreeNode target)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertNull(target, "target");
			TreeNode parent = target.Parent;
			while (parent != null) {
				if (node == parent) {
					return true;
				}
				parent = parent.Parent;
			}
			return false;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public static void SetDropHighlight(TreeNode node)
		{
			ArgumentUtil.AssertNull(node, "node");
			SetDropHighlight(node.TreeView, node);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="node"></param>
		public static void SetDropHighlight(TreeView treeView, TreeNode node)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			uint msg = (uint)TreeViewMessage.TVM_SELECTITEM;
			int wParam = (int)TreeViewGetNextKind.TVGN_DROPHILITE;
			IntPtr hItem = (node == null) ? IntPtr.Zero : node.Handle;
			NativeMethods.SendMessage(treeView.Handle, msg, wParam, hItem);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="imageListHandle"></param>
		/// <returns></returns>
		public static IntPtr SetImageList(TreeView treeView, IntPtr imageListHandle)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			uint msg = (uint)TreeViewMessage.TVM_SETIMAGELIST;
			int wParam = (int)TreeViewImageList.TVSIL_NORMAL;
			return new IntPtr(
					NativeMethods.SendMessage(treeView.Handle, msg, wParam, imageListHandle));
		}

		/// <summary>
		/// c[m[h̉ɃvXL\邩ǂw肵܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="visible"></param>
		public static void SetPlusVisible(TreeNode node, bool visible)
		{
			ArgumentUtil.AssertNull(node, "node");
			if (node.TreeView == null) {
				throw new ArgumentException("TreeNode  TreeView Ɋ蓖ĂĂ܂B", "node");
			}
			uint msg = (uint)(Marshal.SystemDefaultCharSize == 1 ?
					TreeViewMessage.TVM_SETITEMA : TreeViewMessage.TVM_SETITEMW);
			TreeViewItemChildren children
					= visible ? TreeViewItemChildren.NonZero : TreeViewItemChildren.Zero;
			var tvi = new TVITEM(TreeViewItemMask.TVIF_CHILDREN, node, children);
			NativeMethods.SendMessage(node.TreeView.Handle, msg, 0, tvi);
		}

		/// <summary>
		/// c[m[h̉ɃvXL\邩ǂw肵܂B
		/// </summary>
		/// <param name="node"></param>
		/// <param name="visible"></param>
		public static void SetPlusVisible(TreeNodeCollection nodes, bool visible)
		{
			foreach (TreeNode node in nodes) {
				SetPlusVisible(node, visible);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="action"></param>
		public static void Update(TreeView treeView, Action action)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			treeView.BeginUpdate();
			try {
				action();
			} finally {
				treeView.EndUpdate();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="treeView"></param>
		/// <param name="action"></param>
		public static T Update<T>(TreeView treeView, Func<T> action)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			treeView.BeginUpdate();
			try {
				return action();
			} finally {
				treeView.EndUpdate();
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="dest"></param>
		/// <param name="nodeGenerator"></param>
		/// <param name="depth"></param>
		private static void ConvertNodesInternal(
				XmlNode source, object dest, Func<object, TreeNode> nodeGenerator, int depth)
		{
			TreeManager.Convert(source, dest,
					XmlTreeManager.Default, TreeViewTreeManager.Default, nodeGenerator, depth);
		}
	}
}
