using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// 
	/// </summary>
	public class XmlTreeViewBinding : AbstractTreeViewBinding<XmlElement, XmlTreeNode>
	{
		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public XmlElement Root
		{
			get {
				return this.root;
			}
			set {
				if (value != this.root) {
					this.root = value;
					if (this.treeView != null) {
						this.CreateTree();
					}
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Func<XmlElement, XmlTreeNode> ElementConverter { get; set; }

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="root"></param>
		/// <param name="treeView"></param>
		/// <param name="elementConverter"></param>
		public XmlTreeViewBinding(
				XmlElement root, TreeView treeView, Func<XmlElement, XmlTreeNode> elementConverter)
		{
			this.ElementConverter = elementConverter;
			this.Root = root;
			this.TreeView = treeView;
		}

		// public \bh //

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		protected override void CreateSubTreeInternal(XmlTreeNode node)
		{
			TreeViewUtil.ConvertNodes(node.Data, node, this.CreateTreeNode, 0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		protected override void CreateTreeInternal(XmlElement element)
		{
			TreeViewUtil.ConvertNodes(element, this.treeView, this.CreateTreeNode, 0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected override TreeNode CreateTreeNode(object element)
		{
			if (element is XmlElement) {
				return this.ElementConverter((XmlElement)element);
			} else {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected override IEnumerable<XmlElement> GetChildren(XmlElement element)
		{
			foreach (XmlElement child in element.ChildNodes) {
				yield return child;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected override XmlElement GetParent(XmlElement element)
		{
			return element.ParentNode as XmlElement;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected override bool HasChildren(XmlElement element)
		{
			return element.HasChildNodes;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected override bool IsTopLevel(XmlElement element)
		{
			return element.ParentNode.ParentNode is XmlDocument;
		}
	}
}
