using System;
using System.Drawing;
using System.IO;
using System.Runtime.InteropServices;
using System.Security.Permissions;
using System.Text;
using System.Windows.Forms;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	internal static class NativeMethods
	{
		// 萔 //

		internal const string Kernel32Dll = "kernel32.dll";
		internal const string Shell32Dll = "shell32.dll";
		internal const string User32Dll = "user32.dll";

		internal static readonly IntPtr INVALID_HANDLE_VALUE = new IntPtr(-1);

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hObject"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool CloseHandle(IntPtr hObject);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="destination"></param>
		/// <param name="source"></param>
		/// <param name="length"></param>
		[DllImport(Kernel32Dll)]
		internal static extern unsafe void CopyMemory(void* destination, IntPtr source, int length);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpFileName"></param>
		/// <param name="dwDesiredAccess"></param>
		/// <param name="dwShareMode"></param>
		/// <param name="dwCreationDistribution"></param>
		/// <param name="dwFlagsAndAttributes"></param>
		/// <returns></returns>
		internal static IntPtr CreateFile(string lpFileName,
				FileSecurityAndGenericRights dwDesiredAccess,
				FileShare dwShareMode, FileMode dwCreationDistribution,
				FileFlagsAndAttributes dwFlagsAndAttributes)
		{
			return CreateFile(lpFileName, dwDesiredAccess, dwShareMode,
					IntPtr.Zero, dwCreationDistribution, dwFlagsAndAttributes, IntPtr.Zero);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpFileName"></param>
		/// <param name="dwDesiredAccess"></param>
		/// <param name="dwShareMode"></param>
		/// <param name="lpSecurityAttributes"></param>
		/// <param name="dwCreationDistribution"></param>
		/// <param name="dwFlagsAndAttributes"></param>
		/// <param name="hTemplateFile"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, CharSet = CharSet.Auto, SetLastError = true)]
		internal static extern IntPtr CreateFile(string lpFileName,
				FileSecurityAndGenericRights dwDesiredAccess, FileShare dwShareMode,
				IntPtr lpSecurityAttributes, FileMode dwCreationDistribution,
				FileFlagsAndAttributes dwFlagsAndAttributes, IntPtr hTemplateFile);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hIcon"></param>
		/// <returns></returns>
		[DllImport(User32Dll, SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool DestroyIcon(IntPtr hIcon);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pszFile"></param>
		/// <param name="nIconIndex"></param>
		/// <param name="phIconLarge"></param>
		/// <param name="phIconSmall"></param>
		/// <param name="nIcons"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		internal static extern int ExtractIconEx(string pszFile,
				int nIconIndex, IntPtr[] phIconLarge, IntPtr[] phIconSmall, uint nIcons);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hndFindFile"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool FindClose(IntPtr hndFindFile);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pFileName"></param>
		/// <param name="pFindFileData"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, CharSet = CharSet.Auto, SetLastError = true)]
		internal static extern IntPtr FindFirstFile(
				string pFileName, ref WIN32_FIND_DATA pFindFileData);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hndFindFile"></param>
		/// <param name="lpFindFileData"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, CharSet = CharSet.Auto, SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool FindNextFile(
				IntPtr hndFindFile, ref WIN32_FIND_DATA lpFindFileData);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpAppName"></param>
		/// <param name="lpKeyName"></param>
		/// <param name="lpDefault"></param>
		/// <param name="lpReturnedString"></param>
		/// <param name="nSize"></param>
		/// <param name="lpFileName"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll, CharSet = CharSet.Auto)]
		internal static extern int GetPrivateProfileString(string lpAppName, string lpKeyName,
				string lpDefault, StringBuilder lpReturnedString, uint nSize, string lpFileName);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		/// <returns></returns>
		[DllImport(User32Dll, SetLastError = true)]
		internal static extern int GetSystemMetrics(int index);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="cx"></param>
		/// <param name="cy"></param>
		/// <param name="repaint"></param>
		/// <returns></returns>
		[DllImport(User32Dll, SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool MoveWindow(IntPtr hWnd,
				int x, int y, int cx, int cy, [MarshalAs(UnmanagedType.Bool)] bool repaint);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="rect"></param>
		/// <param name="repaint"></param>
		/// <returns></returns>
		internal static bool MoveWindow(IntPtr hWnd, Rectangle rect, bool repaint)
		{
			return MoveWindow(hWnd, rect.Left, rect.Top, rect.Width, rect.Height, repaint);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpPerformanceCount"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool QueryPerformanceCounter(out long lpPerformanceCount);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpFrequency"></param>
		/// <returns></returns>
		[DllImport(Kernel32Dll)]
		[return: MarshalAs(UnmanagedType.Bool)]
		internal static extern bool QueryPerformanceFrequency(out long lpFrequency);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="message"></param>
		/// <returns></returns>
		[DllImport(User32Dll, CharSet = CharSet.Auto, SetLastError = true)]
		internal static extern int RegisterWindowMessage(string message);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="msg"></param>
		/// <param name="wParam"></param>
		/// <param name="lParam"></param>
		/// <returns></returns>
		[DllImport(User32Dll)]
		internal static extern int SendMessage(IntPtr hWnd, uint msg, int wParam, IntPtr lParam);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="msg"></param>
		/// <param name="wParam"></param>
		/// <param name="lParam"></param>
		/// <returns></returns>
		internal static int SendMessage(IntPtr hWnd, uint msg, int wParam, int lParam)
		{
			return SendMessage(hWnd, msg, wParam, new IntPtr(lParam));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="msg"></param>
		/// <param name="wParam"></param>
		/// <param name="lParam"></param>
		/// <returns></returns>
		internal static int SendMessage(IntPtr hWnd, uint msg, int wParam, ValueType lParam)
		{
			IntPtr p = Marshal.AllocHGlobal(Marshal.SizeOf(lParam));
			try {
				Marshal.StructureToPtr(lParam, p, false);
				return SendMessage(hWnd, msg, wParam, p);
			} finally {
				Marshal.DestroyStructure(p, lParam.GetType());
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dwMessage"></param>
		/// <param name="pData"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll)]
		internal static extern uint SHAppBarMessage(AppBarMessage dwMessage, ref APPBARDATA pData);

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal static IShellFolder SHGetDesktopFolder()
		{
			IShellFolder shFolder;
			HRESULT hres = SHGetDesktopFolder(out shFolder);
			Marshal.ThrowExceptionForHR((int)hres);
			return shFolder;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pszPath"></param>
		/// <param name="dwFileAttributes"></param>
		/// <param name="psfi"></param>
		/// <param name="uFlags"></param>
		/// <returns></returns>
		internal static IntPtr SHGetFileInfo(
				string pszPath, FileFlagsAndAttributes dwFileAttributes,
				ref SHFILEINFO psfi, SHGetFileInfoFlags uFlags)
		{
			return SHGetFileInfo(pszPath, dwFileAttributes, ref psfi, (uint)Marshal.SizeOf(psfi), uFlags);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pszPath"></param>
		/// <param name="dwFileAttributes"></param>
		/// <param name="psfi"></param>
		/// <param name="uFlags"></param>
		/// <returns></returns>
		internal static IntPtr SHGetFileInfo(
				IntPtr pszPath, FileFlagsAndAttributes dwFileAttributes,
				ref SHFILEINFO psfi, SHGetFileInfoFlags uFlags)
		{
			return SHGetFileInfo(pszPath, dwFileAttributes, ref psfi, (uint)Marshal.SizeOf(psfi), uFlags);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal static IMalloc SHGetMalloc()
		{
			IMalloc ppMalloc;
			HRESULT hres = SHGetMalloc(out ppMalloc);
			Marshal.ThrowExceptionForHR((int)hres);
			return ppMalloc;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		/// <returns></returns>
		internal static string SHGetPathFromIDList(IntPtr pidl)
		{
			var sb = new StringBuilder(FileUtil.PathMaxLength);
			if (SHGetPathFromIDList(pidl, sb)) {
				return sb.ToString();
			} else {
				return null;
			}
		}
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="nFolder"></param>
		/// <returns></returns>
		internal static IntPtr SHGetSpecialFolderLocation(
				IntPtr hwndOwner, Environment.SpecialFolder nFolder)
		{
			IntPtr pidl;
			HRESULT hres = SHGetSpecialFolderLocation(hwndOwner, nFolder, out pidl);
			Marshal.ThrowExceptionForHR((int)hres);
			return pidl;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lpFileOp"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		internal static extern int SHFileOperation(ref SHFILEOPSTRUCT lpFileOp);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dockStyle"></param>
		/// <returns></returns>
		internal static AppBarEdge ToAppBarEdge(DockStyle dockStyle)
		{
			switch (dockStyle) {
			case DockStyle.Left:
				return AppBarEdge.ABE_LEFT;
			case DockStyle.Top:
				return AppBarEdge.ABE_TOP;
			case DockStyle.Right:
				return AppBarEdge.ABE_RIGHT;
			case DockStyle.Bottom:
				return AppBarEdge.ABE_BOTTOM;
			}
			throw new ArgumentException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="destination"></param>
		/// <param name="length"></param>
		[DllImport(Kernel32Dll)]
		internal static extern void ZeroMemory(IntPtr destination, uint length);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="destination"></param>
		/// <param name="length"></param>
		[DllImport(Kernel32Dll)]
		internal static extern unsafe void ZeroMemory(void* destination, uint length);

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="ppshf"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		private static extern HRESULT SHGetDesktopFolder(out IShellFolder ppshf);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pszPath"></param>
		/// <param name="dwFileAttributes"></param>
		/// <param name="psfi"></param>
		/// <param name="cbSizeFileInfo"></param>
		/// <param name="uFlags"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		private static extern IntPtr SHGetFileInfo(
				string pszPath, FileFlagsAndAttributes dwFileAttributes,
				ref SHFILEINFO psfi, uint cbSizeFileInfo, SHGetFileInfoFlags uFlags);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pszPath"></param>
		/// <param name="dwFileAttributes"></param>
		/// <param name="psfi"></param>
		/// <param name="cbSizeFileInfo"></param>
		/// <param name="uFlags"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		private static extern IntPtr SHGetFileInfo(
				IntPtr pszPath, FileFlagsAndAttributes dwFileAttributes,
				ref SHFILEINFO psfi, uint cbSizeFileInfo, SHGetFileInfoFlags uFlags);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="ppMalloc"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll)]
		private static extern HRESULT SHGetMalloc(out IMalloc ppMalloc);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		/// <param name="pszPath"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll, CharSet = CharSet.Auto)]
		[return: MarshalAs(UnmanagedType.Bool)]
		private static extern bool SHGetPathFromIDList(IntPtr pidl, StringBuilder pszPath);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="nFolder"></param>
		/// <param name="ppidl"></param>
		/// <returns></returns>
		[DllImport(Shell32Dll)]
		private static extern HRESULT SHGetSpecialFolderLocation(
				IntPtr hwndOwner, Environment.SpecialFolder nFolder, out IntPtr ppidl);
	}
}
