using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// lołL[łB
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class DoubleEndedQueue<T> : ReadOnlyCollection<T>
	{
		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public DoubleEndedQueue() : base(new List<T>()) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="collection"></param>
		public DoubleEndedQueue(IEnumerable<T> collection) : base(new List<T>(collection)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="capacity"></param>
		public DoubleEndedQueue(int capacity) : base(new List<T>(capacity)) {}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void Clear()
		{
			this.Items.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public virtual T Dequeue()
		{
			return this.RemoveReturn(0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public virtual T DequeueLast()
		{
			return this.RemoveReturn(this.Count - 1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="item"></param>
		public virtual void Enqueue(T item)
		{
			this.Items.Add(item);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="item"></param>
		public virtual void EnqueueFirst(T item)
		{
			this.Items.Insert(0, item);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		/// <returns></returns>
		private T RemoveReturn(int index)
		{
			T result = this.Items[index];
			this.Items.RemoveAt(index);
			return result;
		}
	}
}
