﻿using System;
using System.Collections.Generic;

namespace SystemNeo.Collections.Generic
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TSource"></typeparam>
	/// <typeparam name="TKey"></typeparam>
	public class KeyEqualityComparer<TSource, TKey> : IEqualityComparer<TSource>
	{
		#region private fields
		private readonly Func<TSource, TKey> keySelector;
		private readonly IEqualityComparer<TKey> keyComparer;
		#endregion

		// public コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="keySelector"></param>
		public KeyEqualityComparer(Func<TSource, TKey> keySelector)
		{
			ArgumentUtil.AssertNull(keySelector, "keySelector");
			this.keySelector = keySelector;
			this.keyComparer = EqualityComparer<TKey>.Default;
		}

		// private メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		bool IEqualityComparer<TSource>.Equals(TSource x, TSource y)
		{
			TKey kx = this.keySelector(x);
			TKey ky = this.keySelector(y);
			return this.keyComparer.Equals(kx, ky);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		int IEqualityComparer<TSource>.GetHashCode(TSource obj)
		{
			TKey key = this.keySelector(obj);
			return this.keyComparer.GetHashCode(key);
		}
	}
}
