﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

using SystemNeo.Collections.Generic;

namespace SystemNeo.Collections
{
	/// <summary>
	/// 
	/// </summary>
	[Obsolete("このクラスは未完成です。", true)]
	public abstract class Tree
	{
		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TBase"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public TNode FindFirst<TBase, TNode>(
				TBase baseNode, Predicate<TNode> match, TreeSearchAlgorithm algorithm, int depth)
				where TBase : class where TNode : class
		{
			ArgumentUtil.AssertNull(baseNode, "baseNode");
			ArgumentUtil.AssertNull(match, "match");
			ArgumentUtil.AssertInvalidEnum(algorithm, "algorithm");
			return this.FindFirstInternal(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public T FindNext<T>(T currentNode, Predicate<T> match, bool loop) where T : class
		{
			return FindInternal<T>(currentNode, match, loop, this.GetForwards);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public T FindPrevious<T>(T currentNode, Predicate<T> match, bool loop) where T : class
		{
			return FindInternal<T>(currentNode, match, loop, this.GetBackwards);
		}

		/// <summary>
		/// 指定したノードの前方にあるノードを逆方向に辿る列挙子を取得します。
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public virtual IEnumerable<T> GetBackwards<T>(T baseNode, bool loop) where T : class
		{
			return new BackwardEnumerable<T>(this, baseNode, loop);
		}

		/// <summary>
		/// 指定したノードの最初の子ノードを取得します。
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public virtual TChild GetFirstChild<TParent, TChild>(TParent node) where TChild : class
		{
			return this.GetChildren<TParent, TChild>(node).FirstOrDefault();
		}

		/// <summary>
		/// 指定したノードの後方にあるノードを順方向に辿る列挙子を取得します。
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public virtual IEnumerable<T> GetForwards<T>(T baseNode, bool loop) where T : class
		{
			return new ForwardEnumerable<T>(this, baseNode, loop);
		}

		/// <summary>
		/// 指定したノードの最後の子ノードを取得します。
		/// </summary>
		/// <param name="node"></param>
		/// <param name="recurse"></param>
		/// <returns></returns>
		public virtual TChild GetLastChild<TParent, TChild>(TParent node, bool recurse)
				where TChild : class
		{
			if (recurse) {
				TChild child = this.GetLastChild<TParent, TChild>(node, false);
				if (child == null) {
					return null;
				} else {
					TChild descendant = this.GetLastChild<TChild, TChild>(child, true);
					return (descendant == null ? child : descendant);
				}
			} else {
				return this.GetChildren<TParent, TChild>(node).LastOrDefault();
			}
		}
				
		// protected メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TParent"></typeparam>
		/// <typeparam name="TChild"></typeparam>
		/// <param name="parent"></param>
		/// <returns></returns>
		protected abstract IEnumerable<TChild> GetChildren<TParent, TChild>(TParent parent);

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="node"></param>
		/// <returns></returns>
		protected abstract T GetNextSibling<T>(T node) where T : class;

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TParent"></typeparam>
		/// <typeparam name="TChild"></typeparam>
		/// <param name="child"></param>
		/// <returns></returns>
		protected abstract TParent GetParent<TParent, TChild>(TChild child)
				where TParent : class;

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="node"></param>
		/// <returns></returns>
		protected abstract T GetPreviousSibling<T>(T node) where T : class;

		// private メソッド //

		/// <summary>
		/// 幅優先探索を行います。
		/// </summary>
		/// <typeparam name="TBase"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private IEnumerable<TNode> FindByBreadthFirstAlgorithm<TBase, TNode>(
				TBase baseNode, Predicate<TNode> match, int depth)
				where TBase : class where TNode : class
		{
			var queue = new Queue();
			queue.Enqueue(baseNode);
			do {
				object node = queue.Dequeue();
				TNode n = node as TNode;
				if (match(n)) {
					yield return n;
				}
				IEnumerable<TNode> children;
				if (n == null) {
					children = this.GetChildren<TBase, TNode>((TBase)node);
				} else {
					children = this.GetChildren<TNode, TNode>(n);
				}
				foreach (TNode childNode in children) {
					queue.Enqueue(childNode);
				}
			} while (queue.Count > 0 && depth-- != 0);
		}

		/// <summary>
		/// 深さ優先探索を行います。
		/// </summary>
		/// <typeparam name="TBase"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private IEnumerable<TNode> FindByDepthFirstAlgorithm<TBase, TNode>(
				TBase baseNode, Predicate<TNode> match, int depth)
				where TBase : class where TNode : class
		{
			if (baseNode is TNode) {
				TNode bn = ObjectUtil.Cast<TNode>(baseNode);
				if (match(bn)) {
					yield return bn;
				}
			}
			if (depth != 0) {
				foreach (TNode child in this.GetChildren<TBase, TNode>(baseNode)) {
					foreach (TNode n in this.FindByDepthFirstAlgorithm(child, match, depth - 1)) {
						yield return n;
					}
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TBase"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private TNode FindFirstInternal<TBase, TNode>(
				TBase baseNode, Predicate<TNode> match, TreeSearchAlgorithm algorithm, int depth)
				where TBase : class where TNode : class
		{
			foreach (TNode node in this.FindInternal(baseNode, match, algorithm, depth)) {
				return node;
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <param name="enumerable"></param>
		/// <returns></returns>
		private static T FindInternal<T>(T currentNode,
				Predicate<T> match, bool loop, Func<T, bool, IEnumerable<T>> enumerable)
				where T : class
		{
			foreach (T node in enumerable(currentNode, loop)) {
				if (match(node)) {
					return node;
				}
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TBase"></typeparam>
		/// <typeparam name="TNode"></typeparam>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		private IEnumerable<TNode> FindInternal<TBase, TNode>(
				TBase baseNode, Predicate<TNode> match, TreeSearchAlgorithm algorithm, int depth)
				where TBase : class where TNode : class
		{
			switch (algorithm) {
			case TreeSearchAlgorithm.BreadthFirstSearch:
				return this.FindByBreadthFirstAlgorithm(baseNode, match, depth);
			case TreeSearchAlgorithm.DepthFirstSearch:
				return this.FindByDepthFirstAlgorithm(baseNode, match, depth);
			default:
				ArgumentUtil.AssertInvalidEnum(algorithm, "algorithm");
				break;
			}
			return null;
		}

		// 型 //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		private class Enumeration<T> : IEnumerable
		{
			// protected フィールド //

			protected readonly T baseNode;
			protected readonly bool loop;
			protected readonly Tree tree;

			// protected コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			protected Enumeration(Tree tree, T baseNode, bool loop)
			{
				this.tree = tree;
				this.baseNode = baseNode;
				this.loop = loop;
			}

			// public メソッド //

			public virtual IEnumerator<T> GetEnumerator()
			{
				throw new NotImplementedException();
			}

			// private メソッド //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			IEnumerator IEnumerable.GetEnumerator()
			{
				return this.GetEnumerator();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		private class BackwardEnumerable<T> : Enumeration<T>, IEnumerable<T> where T : class
		{
			// internal コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			internal BackwardEnumerable(Tree tree, T baseNode, bool loop)
					: base(tree, baseNode, loop) {}

			// private メソッド//

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			IEnumerator<T> IEnumerable<T>.GetEnumerator()
			{
				return new BackwardEnumerator<T>(this.tree, this.baseNode, this.loop);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private class ForwardEnumerable<T> : Enumeration<T>, IEnumerable<T> where T : class
		{
			// internal コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			internal ForwardEnumerable(Tree tree, T baseNode, bool loop)
					: base(tree, baseNode, loop) {}

			// private メソッド//

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			IEnumerator<T> IEnumerable<T>.GetEnumerator()
			{
				return new ForwardEnumerator<T>(this.tree, this.baseNode, this.loop);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		private abstract class AbstractEnumerator<T> : Enumeration<T>, IEnumerator<T>
		{
			// protected フィールド //

			protected T current;
			protected bool ready;

			// protected コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			protected AbstractEnumerator(Tree tree, T baseNode, bool loop)
					: base(tree, baseNode, loop)
			{
				this.current = baseNode;
			}

			// private プロパティ //

			/// <summary>
			/// 
			/// </summary>
			T IEnumerator<T>.Current
			{
				get {
					return this.GetCurrent();
				}
			}

			/// <summary>
			/// 
			/// </summary>
			object IEnumerator.Current
			{
				get {
					return this.GetCurrent();
				}
			}

			// public メソッド //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public abstract bool MoveNext();

			// protected メソッド //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			protected T GetCurrent()
			{
				if (! this.ready) {
					throw new InvalidOperationException();
				}
				return this.current;
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="node"></param>
			/// <returns></returns>
			protected bool MoveNextInternal(T node)
			{
				if (object.ReferenceEquals(node, this.baseNode)) {
					this.ready = false;
				} else {
					this.current = node;
					this.ready = true;
				}
				return this.ready;
			}

			// private メソッド //

			/// <summary>
			/// 
			/// </summary>
			void IEnumerator.Reset()
			{
				this.current = this.baseNode;
				this.ready = false;
			}

			/// <summary>
			/// 
			/// </summary>
			void IDisposable.Dispose() {}
		}

		/// <summary>
		/// 
		/// </summary>
		private class BackwardEnumerator<T> : AbstractEnumerator<T> where T : class
		{
			// internal コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			internal BackwardEnumerator(Tree tree, T baseNode, bool loop)
					: base(tree, baseNode, loop) {}

			// public メソッド //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override bool MoveNext()
			{
				// 兄がいれば、その最後の子孫を選ぶ
				T node = this.tree.GetPreviousSibling(this.current);
				if (node != null) {
					T descendant = this.tree.GetLastChild<T, T>(node, true);
					return this.MoveNextInternal(descendant == null ? node : descendant);
				}
				// 親がいれば選ぶ
				node = this.tree.GetParent<T, T>(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// 自身がルートの場合は、その最後の子孫へ
				if (this.loop) {
					node = this.tree.GetLastChild<T, T>(this.current, true);
					if (node != null) {
						return this.MoveNextInternal(node);
					}
				}
				this.ready = false;
				return false;
			}
		}

		/// <summary>
		/// ノードを順方向に辿る列挙子です。
		/// </summary>
		private class ForwardEnumerator<T> : AbstractEnumerator<T> where T : class
		{
			// internal コンストラクタ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="tree"></param>
			/// <param name="baseNode"></param>
			/// <param name="loop"></param>
			internal ForwardEnumerator(Tree tree, T baseNode, bool loop)
					: base(tree, baseNode, loop) {}

			// public メソッド //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override bool MoveNext()
			{
				// 子がいる場合は、その長子を選ぶ
				T node = this.tree.GetFirstChild<T, T>(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// 弟がいれば選ぶ
				node = this.tree.GetNextSibling(this.current);
				if (node != null) {
					return this.MoveNextInternal(node);
				}
				// 親の弟がいれば選ぶ
				node = this.current;
				for (;;) {
					T parent = this.tree.GetParent<T, T>(node);
					if (parent == null) {
						break;
					}
					T next = this.tree.GetNextSibling(parent);
					if (next != null) {
						return this.MoveNextInternal(next);
					}
					node = parent;
				}
				// 自身が末端の場合は、ルートに戻る
				if (this.loop) {
					node = this.baseNode;
					for (;;) {
						T parent = this.tree.GetParent<T, T>(node);
						if (parent == null) {
							return this.MoveNextInternal(node);
						}
						node = parent;
					}
				}
				this.ready = false;
				return false;
			}
		}
	}
}
