using System;
using System.Configuration;
using System.Drawing;

namespace SystemNeo.Configuration
{
	/// <summary>
	/// 
	/// </summary>
	public static class Settings
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, string defaultValue)
		{
			try {
				return new Result(key, Get(key));
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, int defaultValue)
		{
			try {
				return new Result(key, Convert.ToInt32(Get(key)));
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, int[] defaultValue)
		{
			try {
				int[] result = new int[defaultValue.Length];
				string[] values = Get(key).Split(',');
				for (int i = 0; i < defaultValue.Length; i++) {
					result[i] = Convert.ToInt32(values[i].Trim());
				}
				return new Result(key, result);
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, Point defaultValue)
		{
			try {
				return new Result(key, new PointConverter().ConvertFromString(Get(key)));
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, Size defaultValue)
		{
			try {
				return new Result(key, new SizeConverter().ConvertFromString(Get(key)));
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="type"></param>
		/// <param name="defaultValue"></param>
		/// <returns></returns>
		public static Result Get(string key, Type type, Enum defaultValue)
		{
			try {
				return new Result(key, Enum.Parse(type, Get(key)));
			} catch (Exception e) {
				return new Result(key, defaultValue, e);
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		private static string Get(string key)
		{
			return ConfigurationManager.AppSettings[key];
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public struct Result
		{
			public readonly string Key;
			public readonly object Value;
			public readonly bool Success;
			public readonly Exception Exception;

			// public RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="key"></param>
			/// <param name="value"></param>
			public Result(string key, object value)
			{
				this.Key = key;
				this.Value = value;
				this.Success = true;
				this.Exception = null;
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="key"></param>
			/// <param name="value"></param>
			/// <param name="e"></param>
			public Result(string key, object value, Exception e)
			{
				this.Key = key;
				this.Value = value;
				this.Success = false;
				this.Exception = e;
			}
		}
	}
}
