using System;

namespace SystemNeo
{
	/// <summary>
	/// tƎɊւ郁\bh񋟂܂B
	/// </summary>
	public static class DateTimeUtil
	{
		// public 萔 //

		/// <summary>
		/// 1TԂ̓B
		/// </summary>
		public const int DaysInWeek = 7;

		public const int SecondsPerMinute = 60;
		public const int MinutesPerHour = 60;
		public const int HoursPerDay = 24;
		public const int MinutesPerDay = MinutesPerHour * HoursPerDay;
		public const int SecondsPerHour = SecondsPerMinute * MinutesPerHour;
		public const int SecondsPerDay = SecondsPerHour * HoursPerDay;

		public const int MillisecondsPerSecond = 1000;
		public const int MillisecondsPerMinute = MillisecondsPerSecond * SecondsPerMinute;
		public const int MillisecondsPerHour = MillisecondsPerSecond * SecondsPerHour;
		public const int MillisecondsPerDay = MillisecondsPerSecond * SecondsPerDay;

		// public static \bh //

		/// <summary>
		/// w肵܂ޏT̍ŏ̓擾܂B
		/// </summary>
		/// <param name="date"></param>
		/// <param name="firstDayOfWeek">T̎n܂̗jB</param>
		/// <returns></returns>
		public static DateTime GetFirstDateOfWeek(DateTime date, DayOfWeek firstDayOfWeek)
		{
			ArgumentUtil.AssertInvalidEnum(firstDayOfWeek, "firstDayOfWeek");
			date = date.Date;
			while (date.DayOfWeek != firstDayOfWeek) {
				date = date.AddDays(-1);
			}
			return date;
		}

		/// <summary>
		/// w肵܂ތ̖擾܂B
		/// </summary>
		/// <param name="date"></param>
		/// <returns></returns>
		public static DateTime GetLastDateOfMonth(DateTime date)
		{
			int daysInMonth = DateTime.DaysInMonth(date.Year, date.Month);
			return date.Date.AddDays(daysInMonth - date.Day);
		}

		/// <summary>
		/// w肵܂ތ̎̌̏擾܂B
		/// </summary>
		/// <param name="date"></param>
		/// <returns></returns>
		public static DateTime GetNextMonth(DateTime date)
		{
			return GetLastDateOfMonth(date).AddDays(1);
		}

		/// <summary>
		/// Ԃ̒Pʂw肵 TimeSpan \̂擾܂B
		/// </summary>
		/// <param name="value"></param>
		/// <param name="unit">Ԃ̒PʁB</param>
		/// <returns></returns>
		public static TimeSpan GetTimeSpan(long value, TimeUnit unit)
		{
			ArgumentUtil.AssertInvalidEnum(unit, "unit");
			return new TimeSpan(value * (long)unit);
		}
	}
}
