using System;
using System.Drawing;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// FɊւ郁\bh񋟂܂B
	/// </summary>
	public static class ColorUtil
	{
		// public static tB[h //

		/// <summary>
		/// F̃At@ R|[lg̍őlB
		/// </summary>
		public const int MaxAlpha = 255;

		/// <summary>
		/// F̍őlB
		/// </summary>
		public const double MaxHue = 360.0;

		/// <summary>
		/// F̃At@ R|[lg̍ŏlB
		/// </summary>
		public const int MinAlpha = 0;

		/// <summary>
		/// F̍ŏlB
		/// </summary>
		public const double MinHue = 0.0;

		// public static \bh //

		/// <summary>
		/// AHSB R|[lgiAt@AFAʓxAxjl Color \̂쐬܂B
		/// </summary>
		/// <param name="alpha">At@̃R|[lgB</param>
		/// <param name="hue">FB</param>
		/// <param name="saturation">ʓxB</param>
		/// <param name="brightness">xB</param>
		/// <returns></returns>
		public static Color FromAhsb(int alpha, double hue, double saturation, double brightness)
		{
			if (alpha < MinAlpha || MaxAlpha < alpha) {
				throw new ArgumentOutOfRangeException("alpha");
			}
			if (hue < MinHue || MaxHue < hue) {
				throw new ArgumentOutOfRangeException("hue");
			}
			if (saturation < 0.0 || 1.0 < saturation) {
				throw new ArgumentOutOfRangeException("saturation");
			}
			if (brightness < 0.0 || 1.0 < brightness) {
				throw new ArgumentOutOfRangeException("brightness");
			}

			int hi = (int)Math.Floor(hue / 60.0) % 6;
			double f = hue / 60.0 - hi;
			double p = brightness * (1 - saturation);
			double q = brightness * (1 - saturation * f);
			double t = brightness * (1 - saturation * (1 - f));

			switch (hi) {
			case 0:
				return FromArgb(alpha, brightness, t, p);
			case 1:
				return FromArgb(alpha, q, brightness, p);
			case 2:
				return FromArgb(alpha, p, brightness, t);
			case 3:
				return FromArgb(alpha, p, q, brightness);
			case 4:
				return FromArgb(alpha, t, p, brightness);
			case 5:
				return FromArgb(alpha, brightness, p, q);
			}
			throw new NotImplementedException();
		}

		/// <summary>
		/// S ARGB R|[lgiAt@AԁA΁Ajl Color \̂쐬܂B
		/// </summary>
		/// <param name="alpha">At@̃R|[lgB</param>
		/// <param name="red">Ԃ̃R|[lgB</param>
		/// <param name="green">΂̃R|[lgB</param>
		/// <param name="blue">̃R|[lgB</param>
		/// <returns></returns>
		public static Color FromArgb(int alpha, double red, double green, double blue)
		{
			return Color.FromArgb(alpha, (int)(red * 255), (int)(green * 255), (int)(blue * 255));
		}
	}
}
