using System;
using System.Drawing;
using System.IO;

using SystemNeo.Cache;
using SystemNeo.IO;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// <see cref="SystemNeo.Drawing.ImageCache">ImageCache</see> ̃Gg\܂B
	/// </summary>
	public class ImageCacheEntry : CacheEntry<string, ImageCacheEntry>
	{
		#region private fields
		private Stream stream;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string FileName
		{
			get {
				return this.Key;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public long FileSize
		{
			get {
				return (this.stream == null ? 0 : this.stream.Length);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Image Image { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cache"></param>
		/// <param name="fileName"></param>
		/// <param name="prepared"></param>
		internal ImageCacheEntry(
				ImageCache cache, string fileName, CacheEntryEventHandler<string, ImageCacheEntry> prepared)
				: base(cache, fileName, prepared) {}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public override void Dispose()
		{
			if (this.Image != null) {
				this.Image.Dispose();
				this.Image = null;
				((ImageCache)this.Cache).LoadedImageCount--;
			}
			if (this.stream != null) {
				this.stream.Close();
				this.stream = null;
			}
		}

		// protected \bh //

		/// <summary>
		/// 摜t@Cǂݍ݂܂B
		/// </summary>
		protected override void PrepareInternal()
		{
			if (this.FileName != null && this.FileName != string.Empty) {
				using (var fs = new FileStream(this.FileName, FileMode.Open, FileAccess.Read)) {
					this.stream = StreamUtil.ReadToMemoryStream(fs);
				}
				this.Image = Image.FromStream(this.stream);
				((ImageCache)this.Cache).LoadedImageCount++;
			}
		}
	}
}
