using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;

namespace SystemNeo
{
	/// <summary>
	/// 񋓑̂Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class EnumUtil
	{
		// public static \bh //

		/// <summary>
		/// rbgƂ̘_ς߂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T BitwiseAnd<T>(T x, T y) where T : struct
		{
			return BitwiseInternal<T>(Operators.BitwiseAnd, x, y);
		}

		/// <summary>
		/// rbgƂ̘_a߂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T BitwiseOr<T>(T x, T y) where T : struct
		{
			return BitwiseInternal<T>(Operators.BitwiseOr, x, y);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <param name="boolProperty"></param>
		/// <param name="valueProperty"></param>
		/// <returns></returns>
		public static T GetFlags<T>(IEnumerable e, string boolProperty, string valueProperty)
				where T : struct
		{
			ArgumentUtil.AssertNull(e, "e");
			ArgumentUtil.AssertNull(boolProperty, "boolProperty");
			ArgumentUtil.AssertNull(valueProperty, "valueProperty");
			Type enumType = AssertGenericArgument<T>();
			T result = default(T);
			foreach (object obj in e) {
				var properties = TypeDescriptor.GetProperties(obj);
				object boolValue = properties[boolProperty].GetValue(obj);
				if (boolValue is bool && (bool)boolValue) {
					object enumValue = properties[valueProperty].GetValue(obj);
					if (enumValue is string) {
						enumValue = Enum.Parse(enumType, (string)enumValue);
					}
					if (enumValue is T) {
						result = BitwiseInternal<T>(Operators.BitwiseOr, result, enumValue);
					}
				}
			}
			return result;
		}

		/// <summary>
		/// 񋓑̓̒萔Q擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		public static IEnumerable<T> GetValues<T>() where T : struct
		{
			foreach (T value in Enum.GetValues(typeof(T))) {
				yield return value;
			}
		}

		/// <summary>
		/// w肵l萔񋓑̂ɑ݂邩ǂ𒲂ׂ܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static bool IsDefined(Enum value)
		{
			return Enum.IsDefined(value.GetType(), value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static string ToString(Enum value)
		{
			if (IsDefined(value)) {
				return value.ToString();
			} else {
				return "0x" + value.ToString("X");
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		private static void AssertEnumType(Type type)
		{
			if (! type.IsEnum) {
				throw new NotSupportedException("񋓌^łȂ΂Ȃ܂B");
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		private static Type AssertGenericArgument<T>()
		{
			Type type = typeof(T);
			AssertEnumType(type);
			return type;
		}

		/// <summary>
		/// w肳ꂽrbgZs܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="enumType"></param>
		/// <param name="operator"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		private static T BitwiseInternal<T>(TypedBinaryOperator @operator, object x, object y)
		{
			Type enumType = typeof(T);
			AssertEnumType(enumType);
			object value = @operator(Enum.GetUnderlyingType(enumType), x, y);
			return (T)Enum.ToObject(enumType, value);
		}
	}
}
