using System;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo
{
	/// <summary>
	/// 
	/// </summary>
	public static class FormatterFactory
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="formatExpression"></param>
		/// <returns></returns>
		public static IFormatter Get(string formatExpression)
		{
			return new FormatExpressionFormatter(formatExpression);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="formatter"></param>
		/// <returns></returns>
		public static IFormatter Get<T>(Formatter<T> formatter)
		{
			return new FormatterFormatter<T>(formatter);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="write"></param>
		/// <returns></returns>
		public static IFormatter Get<T>(TextWriteAction<T> write)
		{
			return new ActionFormatter<T>(write);
		}
	}
}
