using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;

namespace SystemNeo
{
	/// <summary>
	/// Q̐lŋ܂ꂽ͈͂\܂B
	/// </summary>
	public struct Int32Range : IEnumerable<int>
	{
		// vpeB //

		/// <summary>
		/// ͈͂̉l擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(0)]
		public int MaxValue { get; set; }

		/// <summary>
		/// ͈͂̏l擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(0)]
		public int MinValue { get; set; }

		/// <summary>
		/// ͈͂̉lƏlƂ̍擾܂͐ݒ肵܂B
		/// </summary>
		/// <remarks>
		/// ̒lݒ肷ƁA͈͂̉l͕ς炸ɏlς܂B
		/// </remarks>
		[DefaultValue(0)]
		public int Range
		{
			get {
				return this.MaxValue - this.MinValue;
			}
			set {
				this.MaxValue = this.MinValue + value;
			}
		}

		// RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="minValue"></param>
		public Int32Range(int minValue) : this(minValue, 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="minValue"></param>
		/// <param name="maxValue"></param>
		public Int32Range(int minValue, int maxValue) : this()
		{
			this.MinValue = minValue;
			this.MaxValue = maxValue;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains(int value)
		{
			return this.MinValue <= value && value <= this.MaxValue;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool Equals(object obj)
		{
			return obj is Int32Range && this.Equals((Int32Range)obj);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Equals(Int32Range value)
		{
			return value.MaxValue == this.MaxValue && value.MinValue == this.MinValue;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public Int32Enumerator GetEnumerator()
		{
			return new Int32Enumerator(this);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode()
		{
			return this.MaxValue ^ this.MinValue;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public bool IsEmpty()
		{
			return this.MinValue > this.MaxValue;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return string.Format("[{0},{1}]", this.MinValue, this.MaxValue);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetEnumerator();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator<int> IEnumerable<int>.GetEnumerator()
		{
			return this.GetEnumerator();
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r1"></param>
		/// <param name="r2"></param>
		/// <returns></returns>
		public static bool operator == (Int32Range r1, Int32Range r2)
		{
			return r1.Equals(r2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r1"></param>
		/// <param name="r2"></param>
		/// <returns></returns>
		public static bool operator != (Int32Range r1, Int32Range r2)
		{
			return ! r1.Equals(r2);
		}

		/// <summary>
		/// Q͈̔͂̋ʕ߂܂B
		/// </summary>
		/// <param name="r1"></param>
		/// <param name="r2"></param>
		/// <returns></returns>
		public static Int32Range operator * (Int32Range r1, Int32Range r2)
		{
			if (r1.MaxValue < r2.MinValue || r2.MaxValue < r2.MinValue) {
				return new Int32Range(1, 0);
			}
			int min = Math.Max(r1.MinValue, r2.MinValue);
			int max = Math.Min(r1.MaxValue, r2.MaxValue);
			return new Int32Range(min, max);
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public sealed class Int32Enumerator : IEnumerator<int>
		{
			#region private fields
			private int current;
			private readonly Int32Range range;
			#endregion

			// RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="range"></param>
			internal Int32Enumerator(Int32Range range)
			{
				this.range = range;
				this.Reset();
			}

			// vpeB //

			/// <summary>
			/// 
			/// </summary>
			public int Current
			{
				get {
					if (this.range.Contains(this.current)) {
						return this.current;
					} else {
						throw new InvalidOperationException();
					}
				}
			}

			/// <summary>
			/// 
			/// </summary>
			object IEnumerator.Current
			{
				get {
					return this.Current;
				}
			}

			// \bh //

			/// <summary>
			/// 
			/// </summary>
			public void Dispose() {}

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public bool MoveNext()
			{
				this.current++;
				return this.range.Contains(this.current);
			}

			/// <summary>
			/// 
			/// </summary>
			public void Reset()
			{
				this.current = this.range.MinValue - 1;
			}
		}
	}
}
