using System;

namespace SystemNeo
{
	/// <summary>
	/// \܂Bx nmiim[gjłB
	/// </summary>
	/// <remarks>
	/// 922km܂ł̒\Ƃł܂B
	/// ͌̕ό]a24{An̕ό]a0.06{ɑ܂B
	/// </remarks>
	public struct Length
	{
		#region private fields
		private readonly long nanometers;
		#endregion

		// public 萔 //

		public const long NanometersPerMicrometer = 1000;
		public const long NanometersPerMillimeter = NanometersPerMicrometer * MicrometersPerMillimeter;
		public const long NanometersPerCentimeter = NanometersPerMillimeter * MillimetersPerCentimeter;
		public const long NanometersPerMeter = NanometersPerMillimeter * MillimetersPerMeter;
		public const long NanometersPerKilometer = NanometersPerMeter * MetersPerKilometer;

		public const long MicrometersPerMillimeter = 1000;
		public const long MicrometersPerCentimeter = MicrometersPerMillimeter * MillimetersPerCentimeter;
		public const long MicrometersPerMeter = MicrometersPerMillimeter * MillimetersPerMeter;
		public const long MicrometersPerKilometer = MicrometersPerMeter * MetersPerKilometer;

		public const long MillimetersPerCentimeter = 10;
		public const long MillimetersPerMeter = MillimetersPerCentimeter * CentimetersPerMeter;
		public const long MillimetersPerKilometer = MillimetersPerMeter * MetersPerKilometer;

		public const long CentimetersPerMeter = 100;
		public const long CentimetersPerKilometer = CentimetersPerMeter * MetersPerKilometer;

		public const long MetersPerKilometer = 1000;

		// public static tB[h //

		public static readonly Length MaxValue = new Length(long.MaxValue);
		public static readonly Length MinValue = new Length(long.MinValue);
		public static readonly Length Zero = new Length(0);

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public double TotalMillimeters
		{
			get {
				return (double)this.nanometers / NanometersPerMillimeter;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public double TotalMeters
		{
			get {
				return (double)this.nanometers / NanometersPerMeter;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public double TotalKilometers
		{
			get {
				return (double)this.nanometers / NanometersPerKilometer;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nanometers"></param>
		public Length(long nanometers)
		{
			this.nanometers = nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="unit"></param>
		public Length(long value, LengthUnit unit)
		{
			ArgumentUtil.AssertInvalidEnum(unit, "unit");
			this.nanometers = value * (long)unit;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="unit"></param>
		public Length(double value, LengthUnit unit)
		{
			ArgumentUtil.AssertInvalidEnum(unit, "unit");
			this.nanometers = (long)(value * (long)unit);
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Length FromMillimeters(double value)
		{
			return new Length((long)(value * NanometersPerMillimeter));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Length FromMeters(double value)
		{
			return new Length((long)(value * NanometersPerMeter));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static Length FromKilometers(double value)
		{
			return new Length((long)(value * NanometersPerKilometer));
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool Equals(object obj)
		{
			return obj is Length && this.nanometers == ((Length)obj).nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode()
		{
			return this.nanometers.GetHashCode();
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static bool operator ==(Length l1, Length l2)
		{
			return l1.nanometers == l2.nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static bool operator !=(Length l1, Length l2)
		{
			return l1.nanometers != l2.nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static bool operator >(Length l1, Length l2)
		{
			return l1.nanometers > l2.nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static bool operator <(Length l1, Length l2)
		{
			return l1.nanometers < l2.nanometers;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static Length operator +(Length l1, Length l2)
		{
			return new Length(l1.nanometers + l2.nanometers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l1"></param>
		/// <param name="l2"></param>
		/// <returns></returns>
		public static Length operator -(Length l1, Length l2)
		{
			return new Length(l1.nanometers - l2.nanometers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l"></param>
		/// <param name="leftCount"></param>
		/// <returns></returns>
		public static Length operator *(Length l, int n)
		{
			return new Length(l.nanometers * n);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l"></param>
		/// <param name="leftCount"></param>
		/// <returns></returns>
		public static Length operator *(Length l, double n)
		{
			return new Length((long)(l.nanometers * n));
		}
	}
}
