using System;
using System.Collections.Generic;
using System.Net;
using System.Net.NetworkInformation;
using System.Net.Sockets;
using System.Threading;

using SystemNeo;
using SystemNeo.Net;

namespace SystemNeo.Net
{
	/// <summary>
	/// [gRs[^B\ǂo邽߂̃\bh񋟂܂B
	/// </summary>
	public static class PingUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="targets">MRs[^Q̃zXg܂IPAhXB</param>
		/// <param name="timeout">҂Ԃ̍őlB</param>
		/// <param name="sending"></param>
		/// <param name="succeeded"></param>
		/// <param name="failed"></param>
		public static void PingSequencially(
				string[] targets, TimeSpan timeout, PingSendingEventHandler sending,
				EventHandler succeeded, PingFailedEventHandler failed)
		{
			ArgumentUtil.AssertNull(targets, "targets");
			if (targets.Length == 0) {
				throw new ArgumentException();
			}
			if (timeout < TimeSpan.Zero) {
				throw new ArgumentOutOfRangeException("timeout");
			}
			new PingAsyncInfo(targets, timeout, sending, succeeded, failed).Next();
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target">MRs[^̃zXg܂IPAhXB</param>
		/// <param name="timeout">҂Ԃ̍őlB</param>
		/// <param name="completed"></param>
		private static void SendAsync(
				string target, TimeSpan timeout, PingCompletedEventHandler completed)
		{
			var ping = new Ping();
			ping.PingCompleted += completed;
			ping.SendAsync(target, (int)timeout.TotalMilliseconds, null);
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private class PingAsyncInfo
		{
			#region private fields
			private readonly PingFailedEventHandler failed;
			private readonly PingSendingEventHandler sending;
			private readonly EventHandler succeeded;
			private readonly Queue<string> targetQueue;
			private readonly TimeSpan timeout;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="targets"></param>
			/// <param name="timeout">҂Ԃ̍őlB</param>
			/// <param name="sending"></param>
			/// <param name="succeeded"></param>
			/// <param name="failed"></param>
			internal PingAsyncInfo(
					string[] targets, TimeSpan timeout, PingSendingEventHandler sending,
					EventHandler succeeded, PingFailedEventHandler failed)
			{
				this.targetQueue = new Queue<string>(targets);
				this.timeout = timeout;
				this.sending = sending;
				this.succeeded = succeeded;
				this.failed = failed;
			}

			// internal \bh //

			/// <summary>
			/// 
			/// </summary>
			internal void Next()
			{
				string target = this.targetQueue.Dequeue();
				var e = new PingSendingEventArgs(target, this.timeout);
				if (this.sending != null) {
					this.sending(typeof(PingUtil), e);
				}
				try {
					SendAsync(target, e.Timeout, this.Completed);
				} catch (PingException ex) {
					this.HandleException(ex);
				} catch (SocketException ex) {
					this.HandleException(ex);
				}
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="sender"></param>
			/// <param name="e"></param>
			private void Completed(object sender, PingCompletedEventArgs e)
			{
				if (e.Error == null) {
					if (e.Reply.Status == IPStatus.Success) {
						this.Succeeded();
						return;
					}
				}
				if (this.failed != null) {
					this.failed(sender, new PingFailedEventArgs(e));
				}
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="ex"></param>
			private void HandleException(Exception ex)
			{
				if (this.failed != null) {
					var e = new PingFailedEventArgs(false, null, ex);
					this.failed(typeof(PingUtil), e);
				}
			}

			/// <summary>
			/// 
			/// </summary>
			private void Succeeded()
			{
				if (this.targetQueue.Count == 0) {
					if (this.succeeded != null) {
						this.succeeded(typeof(PingUtil), EventArgs.Empty);
					}
				} else {
					this.Next();
				}
			}
		}
	}
}
