using System;
using System.Collections.Generic;

using SystemNeo;

namespace SystemNeo.Predicates
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class PredicateProviderCollection<T>
			: List<IPredicateProvider<T>>, IPredicateProvider<T>
	{
		#region private fields
		private LogicalBinaryOperationKind operationKind;
		#endregion

		// public vpeB //

		public Func<T, bool> Func
		{
			get {
				return this.IsMatch;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public LogicalBinaryOperationKind OperationKind
		{
			get {
				return this.operationKind;
			}
			set {
				ArgumentUtil.AssertInvalidEnum(value, "OperationKind");
				this.operationKind = value;
			}
		}

		public Predicate<T> Predicate
		{
			get {
				return this.IsMatch;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="operationKind"></param>
		/// <param name="predicateProviders"></param>
		public PredicateProviderCollection(
				LogicalBinaryOperationKind operationKind,
				params IPredicateProvider<T>[] predicateProviders) : base()
		{
			ArgumentUtil.AssertInvalidEnum(operationKind, "operationKind");
			this.operationKind = operationKind;
			if (predicateProviders != null && predicateProviders.Length > 0) {
				this.AddRange(predicateProviders);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="operationKind"></param>
		/// <param name="predicates"></param>
		public PredicateProviderCollection(
				LogicalBinaryOperationKind operationKind, Predicate<T>[] predicates)
			: this(operationKind)
		{
			if (predicates != null && predicates.Length > 0) {
				foreach (var predicate in predicates) {
					this.Add(new PredicateProvider<T>(predicate));
				}
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public bool IsMatch(T obj)
		{
			Predicate<IPredicateProvider<T>> match = (pp) => pp.IsMatch(obj);
			switch (this.operationKind) {
			case LogicalBinaryOperationKind.And:
				return this.TrueForAll(match);
			case LogicalBinaryOperationKind.ExclusiveOr:
				int index = this.FindIndex(match);
				if (index < 0) {
					// 1}b`Ȃꍇ false
					return false;
				} else if (index == this.Count - 1) {
					// 1}b`ꍇ true
					return true;
				} else {
					// 1}b`A2߂̃}b`Ȃ true
					return (this.FindIndex(index + 1, match) < 0);
				}
			case LogicalBinaryOperationKind.Or:
				return this.FindIndex(match) >= 0;
			}
			throw new NotSupportedException();
		}
	}
}
