using System;
using System.Collections;
using System.Collections.Generic;

namespace SystemNeo
{
	/// <summary>
	/// [WFl[^łB
	/// <see cref="System.Random">Random</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class RandomNeo
	{
		private static readonly RandomNeo @default = new RandomNeo();

		#region private fields
		private readonly Random random;
		#endregion

		// public static vpeB //

		/// <summary>
		/// 
		/// </summary>
		public static RandomNeo Default
		{
			get {
				return @default;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public RandomNeo() : this(new Random()) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="seed"></param>
		public RandomNeo(int seed) : this(new Random(seed)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="random"></param>
		public RandomNeo(Random random)
        {
			ArgumentUtil.AssertNull(random, "random");
			this.random = random;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public int Next()
		{
			return this.Next(0, int.MaxValue);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="maxValue"></param>
		/// <returns></returns>
		public int Next(int maxValue)
		{
			return this.Next(0, maxValue);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="minValue"></param>
		/// <param name="maxValue"></param>
		/// <returns></returns>
		public int Next(int minValue, int maxValue)
		{
			lock (this.random) {
				return this.random.Next(minValue, maxValue);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="range"></param>
		/// <returns></returns>
		public int Next(Int32Range range)
		{
			return this.Next(range.MinValue, range.MaxValue);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="minValue"></param>
		/// <param name="maxValue"></param>
		/// <returns></returns>
		public double Next(double minValue, double maxValue)
		{
			lock (this.random) {
				double r = this.random.NextDouble();
				return minValue + r * (maxValue - minValue);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="list"></param>
		/// <returns></returns>
		public T Next<T>(IList<T> list)
		{
			ArgumentUtil.AssertNull(list, "list");
			return list[this.Next(0, list.Count)];
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public bool NextBoolean()
		{
			lock (this.random) {
				return this.random.NextDouble() < 0.5;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="buffer"></param>
		public void NextBytes(byte[] buffer)
		{
			lock (this.random) {
				this.random.NextBytes(buffer);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public double NextDouble()
		{
			return this.Next(0.0, 1.0);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public T NextWithWeight<T>(IEnumerable<KeyValuePair<T, int>> e)
		{
			int sum = 0;
			foreach (var pair in e) {
				if (pair.Value < 0) {
					throw new ArgumentException("Negative value found", "e");
				}
				sum += pair.Value;
			}
			if (sum == 0) {
				throw new ArgumentException("Positive value not found", "e");
			}
			int r = this.Next(sum);
			foreach (var pair in e) {
				r -= pair.Value;
				if (r < 0) {
					return pair.Key;
				}
			}
			throw new NotImplementedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="e"></param>
		/// <returns></returns>
		public T NextWithWeight<T>(IEnumerable<KeyValuePair<T, double>> e)
		{
			double sum = 0.0;
			foreach (var pair in e) {
				if (pair.Value < 0.0) {
					throw new ArgumentException("Negative value found", "e");
				}
				sum += pair.Value;
			}
			if (sum == 0.0) {
				throw new ArgumentException("Positive value not found", "e");
			}
			double r = this.Next(0.0, sum);
			T lastKey = default(T);
			foreach (var pair in e) {
				r -= pair.Value;
				if (r < 0.0) {
					return pair.Key;
				}
				lastKey = pair.Key;
			}
			return lastKey;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="length"></param>
		/// <param name="average"></param>
		/// <returns></returns>
		public int[] Test(int length, int average)
		{
			int[] arr = new int[length];
			lock (this.random) {
				for (int i = length * average; i > 0; i--) {
					arr[this.random.Next(0, length)]++;
				}
			}
			Array.Sort(arr);
			return arr;
		}
	}
}
